/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.protectors;

import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.models.verifiablePresentation.VerifiablePresentationContent;
import com.microsoft.did.sdk.credential.service.models.verifiablePresentation.VerifiablePresentationDescriptor;
import com.microsoft.did.sdk.credential.service.protectors.FormatterHelpersKt;
import com.microsoft.did.sdk.credential.service.protectors.TokenSigner;
import com.microsoft.did.sdk.identifier.models.Identifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/did/sdk/credential/service/protectors/VerifiablePresentationFormatter;", "", "serializer", "Lkotlinx/serialization/json/Json;", "signer", "Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;", "(Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;)V", "createPresentation", "", "verifiableCredential", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "validityInterval", "", "audience", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "verifiableCredentials", "", "nonce", "walletlibrary_release"})
public final class VerifiablePresentationFormatter {
    @NotNull
    private final Json serializer;
    @NotNull
    private final TokenSigner signer;

    @Inject
    public VerifiablePresentationFormatter(@NotNull Json serializer2, @NotNull TokenSigner signer) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.serializer = serializer2;
        this.signer = signer;
    }

    @NotNull
    public final String createPresentation(@NotNull VerifiableCredential verifiableCredential, int validityInterval, @NotNull String audience, @NotNull Identifier responder) {
        Intrinsics.checkNotNullParameter((Object)verifiableCredential, (String)"verifiableCredential");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
        Pair<Long, Long> pair = CollectionsKt.listOf((Object)verifiableCredential.getRaw());
        List list = CollectionsKt.listOf((Object)"https://www.w3.org/2018/credentials/v1");
        List list2 = CollectionsKt.listOf((Object)"VerifiablePresentation");
        VerifiablePresentationDescriptor verifiablePresentation = new VerifiablePresentationDescriptor(list, list2, (List<String>)pair);
        pair = FormatterHelpersKt.createIssuedAndExpiryTime(validityInterval);
        long issuedTime = ((Number)pair.component1()).longValue();
        long expiryTime = ((Number)pair.component2()).longValue();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String vpId = string;
        String responderDid = responder.getId();
        VerifiablePresentationContent contents = new VerifiablePresentationContent(vpId, null, verifiablePresentation, responderDid, issuedTime, expiryTime, issuedTime, audience, null, null, 770, null);
        String serializedContents = this.serializer.encodeToString((SerializationStrategy)VerifiablePresentationContent.Companion.serializer(), (Object)contents);
        return this.signer.signWithIdentifier(serializedContents, responder);
    }

    @NotNull
    public final String createPresentation(@NotNull List<VerifiableCredential> verifiableCredentials, int validityInterval, @NotNull String audience, @NotNull Identifier responder, @NotNull String nonce) {
        Intrinsics.checkNotNullParameter(verifiableCredentials, (String)"verifiableCredentials");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        List rawVerifiableCredentials = new ArrayList();
        Iterable $this$forEach$iv = verifiableCredentials;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VerifiableCredential it = (VerifiableCredential)element$iv;
            boolean bl = false;
            rawVerifiableCredentials.add(it.getRaw());
        }
        Pair<Long, Long> pair = CollectionsKt.listOf((Object)"https://www.w3.org/2018/credentials/v1");
        List list = CollectionsKt.listOf((Object)"VerifiablePresentation");
        VerifiablePresentationDescriptor verifiablePresentation = new VerifiablePresentationDescriptor((List<String>)pair, list, rawVerifiableCredentials);
        pair = FormatterHelpersKt.createIssuedAndExpiryTime(validityInterval);
        long issuedTime = ((Number)pair.component1()).longValue();
        long expiryTime = ((Number)pair.component2()).longValue();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String vpId = string;
        String responderDid = responder.getId();
        VerifiablePresentationContent contents = new VerifiablePresentationContent(vpId, null, verifiablePresentation, responderDid, issuedTime, expiryTime, issuedTime, audience, null, nonce, 258, null);
        String serializedContents = this.serializer.encodeToString((SerializationStrategy)VerifiablePresentationContent.Companion.serializer(), (Object)contents);
        return this.signer.signWithIdentifier(serializedContents, responder);
    }
}

