/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.protectors;

import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.crypto.protocols.jose.jws.JwsToken;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;", "", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "(Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;)V", "signWithIdentifier", "", "payload", "identifier", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "walletlibrary_release"})
public final class TokenSigner {
    @NotNull
    private final EncryptedKeyStore keyStore;

    @Inject
    public TokenSigner(@NotNull EncryptedKeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.keyStore = keyStore;
    }

    @NotNull
    public final String signWithIdentifier(@NotNull String payload, @NotNull Identifier identifier) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        JWSAlgorithm jWSAlgorithm = JWSAlgorithm.ES256K;
        Intrinsics.checkNotNullExpressionValue((Object)jWSAlgorithm, (String)"ES256K");
        JwsToken token = new JwsToken(payload, jWSAlgorithm);
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.ES256K).type(JOSEObjectType.JWT).keyID(identifier.getId() + '#' + identifier.getSignatureKeyReference()).build();
        JWK privateKey = this.keyStore.getKey(identifier.getSignatureKeyReference());
        token.sign(privateKey, header);
        return token.serialize();
    }
}

