/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.protectors;

import com.microsoft.did.sdk.credential.service.models.RevocationRequest;
import com.microsoft.did.sdk.credential.service.models.oidc.RevocationResponseClaims;
import com.microsoft.did.sdk.credential.service.protectors.FormatterHelpersKt;
import com.microsoft.did.sdk.credential.service.protectors.TokenSigner;
import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.nimbusds.jose.jwk.JWK;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/microsoft/did/sdk/credential/service/protectors/RevocationResponseFormatter;", "", "serializer", "Lkotlinx/serialization/json/Json;", "signer", "Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "(Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;)V", "formatResponse", "", "revocationRequest", "Lcom/microsoft/did/sdk/credential/service/models/RevocationRequest;", "expiryInSeconds", "", "signContents", "contents", "Lcom/microsoft/did/sdk/credential/service/models/oidc/RevocationResponseClaims;", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "walletlibrary_release"})
public final class RevocationResponseFormatter {
    @NotNull
    private final Json serializer;
    @NotNull
    private final TokenSigner signer;
    @NotNull
    private final EncryptedKeyStore keyStore;

    @Inject
    public RevocationResponseFormatter(@NotNull Json serializer2, @NotNull TokenSigner signer, @NotNull EncryptedKeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.serializer = serializer2;
        this.signer = signer;
        this.keyStore = keyStore;
    }

    @NotNull
    public final String formatResponse(@NotNull RevocationRequest revocationRequest, int expiryInSeconds) {
        RevocationResponseClaims revocationResponseClaims;
        Intrinsics.checkNotNullParameter((Object)revocationRequest, (String)"revocationRequest");
        Pair<Long, Long> pair = FormatterHelpersKt.createIssuedAndExpiryTime(expiryInSeconds);
        long issuedTime = ((Number)pair.component1()).longValue();
        long expiryTime = ((Number)pair.component2()).longValue();
        Identifier responder = revocationRequest.getOwner();
        JWK keyJwk = this.keyStore.getKey(revocationRequest.getOwner().getSignatureKeyReference());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String responseId = string;
        RevocationResponseClaims $this$formatResponse_u24lambda_u2d0 = revocationResponseClaims = new RevocationResponseClaims(revocationRequest.getRpList(), revocationRequest.getReason(), revocationRequest.getVerifiableCredential().getRaw(), null, 8, null);
        boolean bl = false;
        String string2 = keyJwk.computeThumbprint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyJwk.computeThumbprint().toString()");
        $this$formatResponse_u24lambda_u2d0.setSubject(string2);
        $this$formatResponse_u24lambda_u2d0.setAudience(revocationRequest.getAudience());
        $this$formatResponse_u24lambda_u2d0.setDid(responder.getId());
        $this$formatResponse_u24lambda_u2d0.setPublicKeyJwk(keyJwk.toPublicJWK());
        $this$formatResponse_u24lambda_u2d0.setResponseCreationTime(issuedTime);
        $this$formatResponse_u24lambda_u2d0.setResponseExpirationTime(expiryTime);
        $this$formatResponse_u24lambda_u2d0.setResponseId(responseId);
        RevocationResponseClaims contents = revocationResponseClaims;
        return this.signContents(contents, responder);
    }

    public static /* synthetic */ String formatResponse$default(RevocationResponseFormatter revocationResponseFormatter, RevocationRequest revocationRequest, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3600;
        }
        return revocationResponseFormatter.formatResponse(revocationRequest, n);
    }

    private final String signContents(RevocationResponseClaims contents, Identifier responder) {
        String serializedResponseContent = this.serializer.encodeToString((SerializationStrategy)RevocationResponseClaims.Companion.serializer(), (Object)contents);
        return this.signer.signWithIdentifier(serializedResponseContent, responder);
    }
}

