/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.protectors;

import android.util.Base64;
import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.IssuanceResponse;
import com.microsoft.did.sdk.credential.service.models.attestations.PresentationAttestation;
import com.microsoft.did.sdk.credential.service.models.oidc.AttestationClaimModel;
import com.microsoft.did.sdk.credential.service.models.oidc.IssuanceResponseClaims;
import com.microsoft.did.sdk.credential.service.models.pin.IssuancePin;
import com.microsoft.did.sdk.credential.service.protectors.FormatterHelpersKt;
import com.microsoft.did.sdk.credential.service.protectors.TokenSigner;
import com.microsoft.did.sdk.credential.service.protectors.VerifiablePresentationFormatter;
import com.microsoft.did.sdk.crypto.CryptoOperations;
import com.microsoft.did.sdk.crypto.DigestAlgorithm;
import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.nimbusds.jose.jwk.JWK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJh\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0018H\u0002J8\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0002Jx\u0010$\u001a\u00020#2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u00182\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J<\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130'2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010(\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J8\u0010)\u001a\u00020\u00132\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020\u001bH\u0002J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/microsoft/did/sdk/credential/service/protectors/IssuanceResponseFormatter;", "", "serializer", "Lkotlinx/serialization/json/Json;", "verifiablePresentationFormatter", "Lcom/microsoft/did/sdk/credential/service/protectors/VerifiablePresentationFormatter;", "signer", "Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "(Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/credential/service/protectors/VerifiablePresentationFormatter;Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;)V", "areNoCollectedClaims", "", "requestedVcMap", "", "Lcom/microsoft/did/sdk/credential/service/models/attestations/PresentationAttestation;", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "Lcom/microsoft/did/sdk/credential/service/RequestedVcMap;", "requestedIdTokenMap", "", "Lcom/microsoft/did/sdk/credential/service/RequestedIdTokenMap;", "requestedAccessTokenMap", "Lcom/microsoft/did/sdk/credential/service/RequestedAccessTokenMap;", "requestedSelfAttestedClaimMap", "Lcom/microsoft/did/sdk/credential/service/RequestedSelfAttestedClaimMap;", "createAndSignOidcResponseContent", "issuanceResponse", "Lcom/microsoft/did/sdk/credential/service/IssuanceResponse;", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "issuedTime", "", "expiryTime", "responseId", "attestationResponse", "Lcom/microsoft/did/sdk/credential/service/models/oidc/AttestationClaimModel;", "createAttestationClaimModel", "presentationsAudience", "createPresentations", "", "audience", "formatResponse", "expiryInSeconds", "", "hashIssuancePin", "response", "signContents", "contents", "Lcom/microsoft/did/sdk/credential/service/models/oidc/IssuanceResponseClaims;", "walletlibrary_release"})
public final class IssuanceResponseFormatter {
    @NotNull
    private final Json serializer;
    @NotNull
    private final VerifiablePresentationFormatter verifiablePresentationFormatter;
    @NotNull
    private final TokenSigner signer;
    @NotNull
    private final EncryptedKeyStore keyStore;

    @Inject
    public IssuanceResponseFormatter(@NotNull Json serializer2, @NotNull VerifiablePresentationFormatter verifiablePresentationFormatter, @NotNull TokenSigner signer, @NotNull EncryptedKeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)verifiablePresentationFormatter, (String)"verifiablePresentationFormatter");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.serializer = serializer2;
        this.verifiablePresentationFormatter = verifiablePresentationFormatter;
        this.signer = signer;
        this.keyStore = keyStore;
    }

    @NotNull
    public final String formatResponse(@NotNull Map<PresentationAttestation, VerifiableCredential> requestedVcMap, @NotNull IssuanceResponse issuanceResponse, @NotNull Identifier responder, int expiryInSeconds) {
        Intrinsics.checkNotNullParameter(requestedVcMap, (String)"requestedVcMap");
        Intrinsics.checkNotNullParameter((Object)issuanceResponse, (String)"issuanceResponse");
        Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
        Pair<Long, Long> pair = FormatterHelpersKt.createIssuedAndExpiryTime(expiryInSeconds);
        long issuedTime = ((Number)pair.component1()).longValue();
        long expiryTime = ((Number)pair.component2()).longValue();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String responseId = string;
        AttestationClaimModel attestationResponse = this.createAttestationClaimModel(requestedVcMap, issuanceResponse.getRequestedIdTokenMap(), issuanceResponse.getRequestedAccessTokenMap(), issuanceResponse.getRequestedSelfAttestedClaimMap(), issuanceResponse.getRequest().getEntityIdentifier(), responder);
        return this.createAndSignOidcResponseContent(issuanceResponse, responder, issuedTime, expiryTime, responseId, attestationResponse);
    }

    public static /* synthetic */ String formatResponse$default(IssuanceResponseFormatter issuanceResponseFormatter, Map map, IssuanceResponse issuanceResponse, Identifier identifier, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            map = new LinkedHashMap();
        }
        return issuanceResponseFormatter.formatResponse(map, issuanceResponse, identifier, n);
    }

    private final String createAndSignOidcResponseContent(IssuanceResponse issuanceResponse, Identifier responder, long issuedTime, long expiryTime, String responseId, AttestationClaimModel attestationResponse) {
        IssuanceResponseClaims issuanceResponseClaims;
        JWK key = this.keyStore.getKey(responder.getSignatureKeyReference());
        IssuanceResponseClaims $this$createAndSignOidcResponseContent_u24lambda_u2d0 = issuanceResponseClaims = new IssuanceResponseClaims(issuanceResponse.getRequest().getContractUrl(), attestationResponse);
        boolean bl = false;
        String string = key.computeThumbprint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.computeThumbprint().toString()");
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setSubject(string);
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setAudience(issuanceResponse.getAudience());
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setDid(responder.getId());
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setPin(this.hashIssuancePin(issuanceResponse));
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setPublicKeyJwk(key.toPublicJWK());
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setResponseCreationTime(issuedTime);
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setResponseExpirationTime(expiryTime);
        $this$createAndSignOidcResponseContent_u24lambda_u2d0.setResponseId(responseId);
        IssuanceResponseClaims contents = issuanceResponseClaims;
        return this.signContents(contents, responder);
    }

    private final String signContents(IssuanceResponseClaims contents, Identifier responder) {
        String serializedResponseContent = this.serializer.encodeToString((SerializationStrategy)IssuanceResponseClaims.Companion.serializer(), (Object)contents);
        return this.signer.signWithIdentifier(serializedResponseContent, responder);
    }

    private final AttestationClaimModel createAttestationClaimModel(Map<PresentationAttestation, VerifiableCredential> requestedVcMap, Map<String, String> requestedIdTokenMap, Map<String, String> requestedAccessTokenMap, Map<String, String> requestedSelfAttestedClaimMap, String presentationsAudience, Identifier responder) {
        if (this.areNoCollectedClaims(requestedVcMap, requestedIdTokenMap, requestedAccessTokenMap, requestedSelfAttestedClaimMap)) {
            return new AttestationClaimModel(null, null, null, null, 15, null);
        }
        Map<String, String> presentationAttestations = this.createPresentations(requestedVcMap, presentationsAudience, responder);
        return new AttestationClaimModel(requestedSelfAttestedClaimMap, requestedIdTokenMap, requestedAccessTokenMap, presentationAttestations);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> createPresentations(Map<PresentationAttestation, VerifiableCredential> requestedVcMap, String audience, Identifier responder) {
        void $this$mapTo$iv$iv;
        Map<PresentationAttestation, VerifiableCredential> $this$map$iv = requestedVcMap;
        boolean $i$f$map = false;
        Map<PresentationAttestation, VerifiableCredential> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PresentationAttestation inputDescriptor = (PresentationAttestation)entry.getKey();
            VerifiableCredential vc = (VerifiableCredential)entry.getValue();
            collection.add(TuplesKt.to((Object)inputDescriptor.getCredentialType(), (Object)this.verifiablePresentationFormatter.createPresentation(vc, inputDescriptor.getValidityInterval(), audience, responder)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean areNoCollectedClaims(Map<PresentationAttestation, VerifiableCredential> requestedVcMap, Map<String, String> requestedIdTokenMap, Map<String, String> requestedAccessTokenMap, Map<String, String> requestedSelfAttestedClaimMap) {
        Map<Object, Object> map = requestedVcMap;
        return (map == null || map.isEmpty()) && ((map = requestedIdTokenMap) == null || map.isEmpty()) && ((map = requestedAccessTokenMap) == null || map.isEmpty()) && ((map = requestedSelfAttestedClaimMap) == null || map.isEmpty());
    }

    private final String hashIssuancePin(IssuanceResponse response) {
        String pinValueToHash;
        StringBuilder stringBuilder = new StringBuilder();
        Object object = response.getIssuancePin();
        if (object == null || (object = ((IssuancePin)object).getPinSalt()) == null) {
            object = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append((String)object);
        Object object2 = response.getIssuancePin();
        if (object2 == null || (object2 = ((IssuancePin)object2).getPin()) == null) {
            object2 = "";
        }
        if (((CharSequence)(pinValueToHash = stringBuilder2.append((String)object2).toString())).length() == 0) {
            return null;
        }
        String string = pinValueToHash;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return Base64.encodeToString((byte[])CryptoOperations.INSTANCE.digest(byArray, DigestAlgorithm.Sha256.INSTANCE), (int)2);
    }
}

