/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.models;

import com.microsoft.did.sdk.credential.models.ServiceDescriptor;
import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.models.VcServiceActionRequest;
import com.microsoft.did.sdk.identifier.models.Identifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/did/sdk/credential/service/models/RevocationRequest;", "Lcom/microsoft/did/sdk/credential/service/models/VcServiceActionRequest;", "verifiableCredential", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "owner", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "rpList", "", "", "reason", "(Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;Lcom/microsoft/did/sdk/identifier/models/Identifier;Ljava/util/List;Ljava/lang/String;)V", "getOwner", "()Lcom/microsoft/did/sdk/identifier/models/Identifier;", "getReason", "()Ljava/lang/String;", "getRpList", "()Ljava/util/List;", "getVerifiableCredential", "()Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "walletlibrary_release"})
public final class RevocationRequest
extends VcServiceActionRequest {
    @NotNull
    private final VerifiableCredential verifiableCredential;
    @NotNull
    private final Identifier owner;
    @NotNull
    private final List<String> rpList;
    @NotNull
    private final String reason;

    public RevocationRequest(@NotNull VerifiableCredential verifiableCredential, @NotNull Identifier owner, @NotNull List<String> rpList, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)verifiableCredential, (String)"verifiableCredential");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(rpList, (String)"rpList");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = verifiableCredential.getContents().getVc().getRevokeService();
        if (object == null || (object = ((ServiceDescriptor)object).getId()) == null) {
            object = "";
        }
        super((String)object, null);
        this.verifiableCredential = verifiableCredential;
        this.owner = owner;
        this.rpList = rpList;
        this.reason = reason;
    }

    @NotNull
    public final VerifiableCredential getVerifiableCredential() {
        return this.verifiableCredential;
    }

    @NotNull
    public final Identifier getOwner() {
        return this.owner;
    }

    @NotNull
    public final List<String> getRpList() {
        return this.rpList;
    }

    @NotNull
    public final String getReason() {
        return this.reason;
    }

    @NotNull
    public final VerifiableCredential component1() {
        return this.verifiableCredential;
    }

    @NotNull
    public final Identifier component2() {
        return this.owner;
    }

    @NotNull
    public final List<String> component3() {
        return this.rpList;
    }

    @NotNull
    public final String component4() {
        return this.reason;
    }

    @NotNull
    public final RevocationRequest copy(@NotNull VerifiableCredential verifiableCredential, @NotNull Identifier owner, @NotNull List<String> rpList, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)verifiableCredential, (String)"verifiableCredential");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(rpList, (String)"rpList");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return new RevocationRequest(verifiableCredential, owner, rpList, reason);
    }

    public static /* synthetic */ RevocationRequest copy$default(RevocationRequest revocationRequest, VerifiableCredential verifiableCredential, Identifier identifier, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            verifiableCredential = revocationRequest.verifiableCredential;
        }
        if ((n & 2) != 0) {
            identifier = revocationRequest.owner;
        }
        if ((n & 4) != 0) {
            list = revocationRequest.rpList;
        }
        if ((n & 8) != 0) {
            string = revocationRequest.reason;
        }
        return revocationRequest.copy(verifiableCredential, identifier, list, string);
    }

    @NotNull
    public String toString() {
        return "RevocationRequest(verifiableCredential=" + this.verifiableCredential + ", owner=" + this.owner + ", rpList=" + this.rpList + ", reason=" + this.reason + ')';
    }

    public int hashCode() {
        int result = this.verifiableCredential.hashCode();
        result = result * 31 + this.owner.hashCode();
        result = result * 31 + ((Object)this.rpList).hashCode();
        result = result * 31 + this.reason.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RevocationRequest)) {
            return false;
        }
        RevocationRequest revocationRequest = (RevocationRequest)other;
        if (!Intrinsics.areEqual((Object)this.verifiableCredential, (Object)revocationRequest.verifiableCredential)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)revocationRequest.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rpList, revocationRequest.rpList)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reason, (Object)revocationRequest.reason);
    }
}

