/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.backup.container.jwe;

import com.microsoft.did.sdk.backup.container.ProtectionMethod;
import com.microsoft.did.sdk.backup.container.jwe.JwePasswordProtectedBackupData;
import com.microsoft.did.sdk.backup.content.ProtectedBackupData;
import com.microsoft.did.sdk.backup.content.UnprotectedBackupData;
import com.microsoft.did.sdk.crypto.protocols.jose.jwe.JweToken;
import com.microsoft.did.sdk.util.controlflow.BadPasswordException;
import com.microsoft.did.sdk.util.controlflow.FailedDecryptException;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/did/sdk/backup/container/jwe/JwePasswordProtectionMethod;", "Lcom/microsoft/did/sdk/backup/container/ProtectionMethod;", "password", "", "(Ljava/lang/String;)V", "getPassword", "()Ljava/lang/String;", "unwrap", "Lcom/microsoft/did/sdk/backup/content/UnprotectedBackupData;", "protectedBackupData", "Lcom/microsoft/did/sdk/backup/content/ProtectedBackupData;", "serializer", "Lkotlinx/serialization/json/Json;", "wrap", "unprotectedBackupData", "walletlibrary_release"})
public final class JwePasswordProtectionMethod
extends ProtectionMethod {
    @NotNull
    private final String password;

    public JwePasswordProtectionMethod(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.password = password;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public ProtectedBackupData wrap(@NotNull UnprotectedBackupData unprotectedBackupData, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)unprotectedBackupData, (String)"unprotectedBackupData");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        StringFormat $this$encodeToString$iv = (StringFormat)serializer2;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(UnprotectedBackupData.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        String data = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)unprotectedBackupData);
        JweToken token = new JweToken(data, null, null, 6, null);
        JWEHeader headers = new JWEHeader.Builder(JWEAlgorithm.PBES2_HS512_A256KW, EncryptionMethod.A256CBC_HS512).contentType(unprotectedBackupData.getType()).build();
        String string = this.password;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        OctetSequenceKey secretKey = new OctetSequenceKey.Builder(byArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"secretKey");
        token.encrypt((JWK)secretKey, headers);
        return new JwePasswordProtectedBackupData(token);
    }

    @Override
    @NotNull
    public UnprotectedBackupData unwrap(@NotNull ProtectedBackupData protectedBackupData, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)protectedBackupData, (String)"protectedBackupData");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        if (!(protectedBackupData instanceof JwePasswordProtectedBackupData)) {
            throw new FailedDecryptException("Protection paramaters do not match backup contents", null, false, 6, null);
        }
        if (((CharSequence)this.password).length() == 0) {
            throw new BadPasswordException("Password can't be empty", null, false, 6, null);
        }
        String string = this.password;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        SecretKeySpec secretKey = new SecretKeySpec(byArray, "RAW");
        byte[] data = JweToken.decrypt$default(((JwePasswordProtectedBackupData)protectedBackupData).getJweToken(), null, secretKey, 1, null);
        return (UnprotectedBackupData)serializer2.decodeFromString((DeserializationStrategy)UnprotectedBackupData.Companion.serializer(), new String(data, Charsets.UTF_8));
    }
}

