/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.backup;

import com.microsoft.did.sdk.backup.container.jwe.JwePasswordProtectedBackupData;
import com.microsoft.did.sdk.backup.content.ProtectedBackupData;
import com.microsoft.did.sdk.crypto.protocols.jose.jwe.JweToken;
import com.microsoft.did.sdk.util.controlflow.UnknownBackupFormatException;
import com.microsoft.did.sdk.util.controlflow.UnknownProtectionMethodException;
import com.nimbusds.jose.JWEAlgorithm;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/did/sdk/backup/BackupParser;", "", "()V", "parseBackup", "Lcom/microsoft/did/sdk/backup/content/ProtectedBackupData;", "jweString", "", "walletlibrary_release"})
public final class BackupParser {
    @Inject
    public BackupParser() {
    }

    @NotNull
    public final ProtectedBackupData parseBackup(@NotNull String jweString) {
        Intrinsics.checkNotNullParameter((Object)jweString, (String)"jweString");
        JweToken token = JweToken.Companion.deserialize(jweString);
        String cty = token.getContentType();
        if (!Intrinsics.areEqual((Object)cty, (Object)"MicrosoftWallet2020")) {
            throw new UnknownBackupFormatException("Backup of an unknown format: " + cty, null, 2, null);
        }
        JWEAlgorithm alg = token.getKeyAlgorithm();
        String string = alg.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg.name");
        if (StringsKt.startsWith$default((String)string, (String)"PBE", (boolean)false, (int)2, null)) {
            return new JwePasswordProtectedBackupData(token);
        }
        throw new UnknownProtectionMethodException("Unknown backup protection method: " + alg, null, 2, null);
    }
}

