/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk;

import android.net.Uri;
import com.microsoft.did.sdk.IdentifierService;
import com.microsoft.did.sdk.LinkedDomainsService;
import com.microsoft.did.sdk.PresentationService;
import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.PresentationRequest;
import com.microsoft.did.sdk.credential.service.PresentationResponse;
import com.microsoft.did.sdk.credential.service.models.linkedDomains.LinkedDomainResult;
import com.microsoft.did.sdk.credential.service.models.oidc.PresentationRequestContent;
import com.microsoft.did.sdk.credential.service.models.presentationexchange.CredentialPresentationInputDescriptor;
import com.microsoft.did.sdk.credential.service.protectors.PresentationResponseFormatter;
import com.microsoft.did.sdk.credential.service.validators.JwtValidator;
import com.microsoft.did.sdk.credential.service.validators.PresentationRequestValidator;
import com.microsoft.did.sdk.crypto.protocols.jose.jws.JwsToken;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.datasource.network.credentialOperations.FetchPresentationRequestNetworkOperation;
import com.microsoft.did.sdk.datasource.network.credentialOperations.SendPresentationResponseNetworkOperation;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.microsoft.did.sdk.internal.ImageLoader;
import com.microsoft.did.sdk.util.DidDeepLinkUtil;
import com.microsoft.did.sdk.util.controlflow.InvalidSignatureException;
import com.microsoft.did.sdk.util.controlflow.PresentationException;
import com.microsoft.did.sdk.util.controlflow.Result;
import com.microsoft.did.sdk.util.controlflow.ResultKt;
import com.microsoft.did.sdk.util.controlflow.RunResultTryContext;
import com.microsoft.did.sdk.util.log.SdkLog;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018JI\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u0002`#2\b\b\u0002\u0010$\u001a\u00020%H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010(\u001a\u00020)H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00142\u0006\u0010-\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010/\u001a\u00020,H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u001f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u00104\u001a\u00020\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0010\u00105\u001a\u00020)2\u0006\u0010(\u001a\u00020\u0017H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lcom/microsoft/did/sdk/PresentationService;", "", "identifierService", "Lcom/microsoft/did/sdk/IdentifierService;", "linkedDomainsService", "Lcom/microsoft/did/sdk/LinkedDomainsService;", "serializer", "Lkotlinx/serialization/json/Json;", "jwtValidator", "Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;", "presentationRequestValidator", "Lcom/microsoft/did/sdk/credential/service/validators/PresentationRequestValidator;", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "presentationResponseFormatter", "Lcom/microsoft/did/sdk/credential/service/protectors/PresentationResponseFormatter;", "imageLoader", "Lcom/microsoft/did/sdk/internal/ImageLoader;", "(Lcom/microsoft/did/sdk/IdentifierService;Lcom/microsoft/did/sdk/LinkedDomainsService;Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;Lcom/microsoft/did/sdk/credential/service/validators/PresentationRequestValidator;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;Lcom/microsoft/did/sdk/credential/service/protectors/PresentationResponseFormatter;Lcom/microsoft/did/sdk/internal/ImageLoader;)V", "fetchRequest", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "Lcom/microsoft/did/sdk/credential/service/models/oidc/PresentationRequestContent;", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "formAndSendResponse", "", "response", "Lcom/microsoft/did/sdk/credential/service/PresentationResponse;", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "requestedVcPresentationSubmissionMap", "", "Lcom/microsoft/did/sdk/credential/service/models/presentationexchange/CredentialPresentationInputDescriptor;", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "Lcom/microsoft/did/sdk/credential/service/RequestedVcPresentationSubmissionMap;", "expiryInSeconds", "", "(Lcom/microsoft/did/sdk/credential/service/PresentationResponse;Lcom/microsoft/did/sdk/identifier/models/Identifier;Ljava/util/Map;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPresentationRequestContent", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRequest", "Lcom/microsoft/did/sdk/credential/service/PresentationRequest;", "stringUri", "isRequestValid", "request", "(Lcom/microsoft/did/sdk/credential/service/PresentationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendResponse", "(Lcom/microsoft/did/sdk/credential/service/PresentationResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyAndUnwrapPresentationRequestFromQueryParam", "jwsTokenString", "verifyUri", "walletlibrary_release"})
public final class PresentationService {
    @NotNull
    private final IdentifierService identifierService;
    @NotNull
    private final LinkedDomainsService linkedDomainsService;
    @NotNull
    private final Json serializer;
    @NotNull
    private final JwtValidator jwtValidator;
    @NotNull
    private final PresentationRequestValidator presentationRequestValidator;
    @NotNull
    private final ApiProvider apiProvider;
    @NotNull
    private final PresentationResponseFormatter presentationResponseFormatter;
    @NotNull
    private final ImageLoader imageLoader;

    @Inject
    public PresentationService(@NotNull IdentifierService identifierService, @NotNull LinkedDomainsService linkedDomainsService, @NotNull Json serializer2, @NotNull JwtValidator jwtValidator, @NotNull PresentationRequestValidator presentationRequestValidator, @NotNull ApiProvider apiProvider, @NotNull PresentationResponseFormatter presentationResponseFormatter, @NotNull ImageLoader imageLoader) {
        Intrinsics.checkNotNullParameter((Object)identifierService, (String)"identifierService");
        Intrinsics.checkNotNullParameter((Object)linkedDomainsService, (String)"linkedDomainsService");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)jwtValidator, (String)"jwtValidator");
        Intrinsics.checkNotNullParameter((Object)presentationRequestValidator, (String)"presentationRequestValidator");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)presentationResponseFormatter, (String)"presentationResponseFormatter");
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        this.identifierService = identifierService;
        this.linkedDomainsService = linkedDomainsService;
        this.serializer = serializer2;
        this.jwtValidator = jwtValidator;
        this.presentationRequestValidator = presentationRequestValidator;
        this.apiProvider = apiProvider;
        this.presentationResponseFormatter = presentationResponseFormatter;
        this.imageLoader = imageLoader;
    }

    @Nullable
    public final Object getRequest(@NotNull String stringUri, @NotNull Continuation<? super Result<PresentationRequest>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends PresentationRequest>>, Object>(this, stringUri, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PresentationService this$0;
            final /* synthetic */ String $stringUri;
            {
                this.this$0 = $receiver;
                this.$stringUri = $stringUri;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        var3_4 = "Presentation getRequest";
                        var4_5 = this.this$0;
                        var5_6 = this.$stringUri;
                        $i$f$logTime = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-logTime-PresentationService$getRequest$2$1 = false;
                        uri = PresentationService.access$verifyUri(var4_5, var5_6);
                        var11_19 = $this$runResultTry;
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = var11_19;
                        this.J$0 = start$iv;
                        this.label = 1;
                        v0 = PresentationService.access$getPresentationRequestContent(var4_5, uri, (Continuation)this);
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl34
                    }
                    case 1: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        var11_19 = (Pair[])this.L$3;
                        var4_5 = (PresentationService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 2 sources

                        presentationRequestContent = (PresentationRequestContent)var11_19.abortOnError((Result)v0);
                        var11_19 = $this$runResultTry;
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = var11_19;
                        this.L$4 = presentationRequestContent;
                        this.J$0 = start$iv;
                        this.label = 2;
                        v1 = PresentationService.access$getLinkedDomainsService$p(var4_5).fetchAndVerifyLinkedDomains(presentationRequestContent.getClientId(), (Continuation<? super Result<? extends LinkedDomainResult>>)this);
                        if (v1 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl58
                    }
                    case 2: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        presentationRequestContent = (PresentationRequestContent)this.L$4;
                        var11_19 = (RunResultTryContext)this.L$3;
                        var4_5 = (PresentationService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl58:
                        // 2 sources

                        linkedDomainResult = (LinkedDomainResult)var11_19.abortOnError((Result)v1);
                        request = new PresentationRequest(presentationRequestContent, linkedDomainResult);
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = request;
                        this.L$4 = null;
                        this.J$0 = start$iv;
                        this.label = 3;
                        v2 = PresentationService.access$getImageLoader$p(var4_5).loadRemoteImage(request, (Continuation<? super Unit>)this);
                        if (v2 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl81
                    }
                    case 3: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        request = (PresentationRequest)this.L$3;
                        var4_5 = (PresentationService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl81:
                        // 2 sources

                        var11_19 = $this$runResultTry;
                        this.L$0 = name$iv;
                        this.L$1 = var11_19;
                        this.L$2 = request;
                        this.L$3 = null;
                        this.J$0 = start$iv;
                        this.label = 4;
                        v3 = PresentationService.access$isRequestValid(var4_5, request, (Continuation)this);
                        if (v3 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl101
                    }
                    case 4: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        request = (PresentationRequest)this.L$2;
                        var11_19 = (RunResultTryContext)this.L$1;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl101:
                        // 2 sources

                        var11_19.abortOnError((Result)v3);
                        result$iv = new Result.Success<PresentationRequest>(request);
                        elapsedTime$iv = System.currentTimeMillis() - start$iv;
                        var11_19 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv))};
                        SdkLog.INSTANCE.event("DIDPerformanceMetrics", MapsKt.mapOf((Pair[])var11_19));
                        return result$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<RunResultTryContext, Continuation<? super Result<? extends PresentationRequest>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<PresentationRequest>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Uri verifyUri(String uri) {
        Uri url = Uri.parse((String)uri);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
        if (!DidDeepLinkUtil.INSTANCE.isDidDeepLink(url)) {
            throw new PresentationException("Request Protocol not supported.", null, false, 6, null);
        }
        return url;
    }

    private final Object getPresentationRequestContent(Uri uri, Continuation<? super Result<PresentationRequestContent>> $completion) {
        String requestParameter = uri.getQueryParameter("request");
        if (requestParameter != null) {
            return this.verifyAndUnwrapPresentationRequestFromQueryParam(requestParameter, $completion);
        }
        String requestUriParameter = uri.getQueryParameter("request_uri");
        if (requestUriParameter != null) {
            return this.fetchRequest(requestUriParameter, $completion);
        }
        return new Result.Failure(new PresentationException("No query parameter 'request' nor 'request_uri' is passed.", null, false, 6, null));
    }

    private final Object isRequestValid(PresentationRequest request, Continuation<? super Result<Unit>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends Unit>>, Object>(this, request, null){
            int label;
            final /* synthetic */ PresentationService this$0;
            final /* synthetic */ PresentationRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PresentationService.access$getPresentationRequestValidator$p(this.this$0).validate(this.$request, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return new Result.Success<Unit>(Unit.INSTANCE);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return new Result.Success<Unit>(Unit.INSTANCE);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object verifyAndUnwrapPresentationRequestFromQueryParam(String var1_1, Continuation<? super Result<PresentationRequestContent>> var2_2) {
        if (!(var2_2 instanceof verifyAndUnwrapPresentationRequestFromQueryParam.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PresentationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PresentationService.access$verifyAndUnwrapPresentationRequestFromQueryParam(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                kotlin.ResultKt.throwOnFailure((Object)$result);
                jwsToken = JwsToken.Companion.deserialize((String)jwsTokenString);
                $continuation.L$0 = this;
                $continuation.L$1 = jwsToken;
                $continuation.label = 1;
                v0 = this.jwtValidator.verifySignature(jwsToken, (Continuation<? super Boolean>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                jwsToken = (JwsToken)$continuation.L$1;
                this = (PresentationService)$continuation.L$0;
                kotlin.ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    throw new InvalidSignatureException("Signature is not valid on Presentation Request.");
                }
                return new Result.Success<Object>(this.serializer.decodeFromString((DeserializationStrategy)PresentationRequestContent.Companion.serializer(), jwsToken.content()));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object fetchRequest(String url, Continuation<? super Result<PresentationRequestContent>> $completion) {
        return new FetchPresentationRequestNetworkOperation(url, this.apiProvider, this.jwtValidator, this.serializer).fire($completion);
    }

    @Nullable
    public final Object sendResponse(@NotNull PresentationResponse response, @NotNull Continuation<? super Result<Unit>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends Unit>>, Object>(this, response, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PresentationService this$0;
            final /* synthetic */ PresentationResponse $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        var3_4 = "Presentation sendResponse";
                        var4_5 = this.this$0;
                        var5_6 = this.$response;
                        $i$f$logTime = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-logTime-PresentationService$sendResponse$2$1 = false;
                        var10_14 = $this$runResultTry;
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = var10_14;
                        this.J$0 = start$iv;
                        this.label = 1;
                        v0 = PresentationService.access$getIdentifierService$p(var4_5).getMasterIdentifier((Continuation<? super Result<Identifier>>)this);
                        if (v0 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$sendResponse$2$1 = false;
                        start$iv = this.J$0;
                        var10_14 = (RunResultTryContext)this.L$4;
                        var5_6 = (PresentationResponse)this.L$3;
                        var4_5 = (PresentationService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        masterIdentifier = (Identifier)var10_14.abortOnError((Result)v0);
                        vcRequestedMapping = var5_6.getRequestedVcPresentationSubmissionMap();
                        var10_14 = $this$runResultTry;
                        this.L$0 = name$iv;
                        this.L$1 = var10_14;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.J$0 = start$iv;
                        this.label = 2;
                        v1 = PresentationService.formAndSendResponse$default(var4_5, var5_6, masterIdentifier, vcRequestedMapping, 0, (Continuation)this, 8, null);
                        if (v1 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl57
                    }
                    case 2: {
                        $i$f$logTime = false;
                        $i$a$-logTime-PresentationService$sendResponse$2$1 = false;
                        start$iv = this.J$0;
                        var10_14 = (RunResultTryContext)this.L$1;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl57:
                        // 2 sources

                        var10_14.abortOnError((Result)v1);
                        result$iv = Unit.INSTANCE;
                        elapsedTime$iv = System.currentTimeMillis() - start$iv;
                        var11_19 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv))};
                        SdkLog.INSTANCE.event("DIDPerformanceMetrics", MapsKt.mapOf((Pair[])var11_19));
                        return new Result.Success<Unit>(Unit.INSTANCE);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<RunResultTryContext, Continuation<? super Result<? extends Unit>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Object formAndSendResponse(PresentationResponse response, Identifier responder, Map<CredentialPresentationInputDescriptor, VerifiableCredential> requestedVcPresentationSubmissionMap, int expiryInSeconds, Continuation<? super Result<Unit>> $completion) {
        Pair<String, String> pair = this.presentationResponseFormatter.formatResponse(requestedVcPresentationSubmissionMap, response, responder, expiryInSeconds);
        String idToken = (String)pair.component1();
        String vpToken = (String)pair.component2();
        return new SendPresentationResponseNetworkOperation(response.getRequest().getContent().getRedirectUrl(), idToken, vpToken, response.getRequest().getContent().getState(), this.apiProvider).fire($completion);
    }

    static /* synthetic */ Object formAndSendResponse$default(PresentationService presentationService, PresentationResponse presentationResponse, Identifier identifier, Map map, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 3600;
        }
        return presentationService.formAndSendResponse(presentationResponse, identifier, map, n, (Continuation<? super Result<Unit>>)continuation);
    }

    public static final /* synthetic */ Uri access$verifyUri(PresentationService $this, String uri) {
        return $this.verifyUri(uri);
    }

    public static final /* synthetic */ Object access$getPresentationRequestContent(PresentationService $this, Uri uri, Continuation $completion) {
        return $this.getPresentationRequestContent(uri, (Continuation<? super Result<PresentationRequestContent>>)$completion);
    }

    public static final /* synthetic */ LinkedDomainsService access$getLinkedDomainsService$p(PresentationService $this) {
        return $this.linkedDomainsService;
    }

    public static final /* synthetic */ ImageLoader access$getImageLoader$p(PresentationService $this) {
        return $this.imageLoader;
    }

    public static final /* synthetic */ Object access$isRequestValid(PresentationService $this, PresentationRequest request, Continuation $completion) {
        return $this.isRequestValid(request, (Continuation<? super Result<Unit>>)$completion);
    }

    public static final /* synthetic */ PresentationRequestValidator access$getPresentationRequestValidator$p(PresentationService $this) {
        return $this.presentationRequestValidator;
    }

    public static final /* synthetic */ Object access$verifyAndUnwrapPresentationRequestFromQueryParam(PresentationService $this, String jwsTokenString, Continuation $completion) {
        return $this.verifyAndUnwrapPresentationRequestFromQueryParam(jwsTokenString, (Continuation<? super Result<PresentationRequestContent>>)$completion);
    }

    public static final /* synthetic */ Object access$fetchRequest(PresentationService $this, String url, Continuation $completion) {
        return $this.fetchRequest(url, (Continuation<? super Result<PresentationRequestContent>>)$completion);
    }

    public static final /* synthetic */ IdentifierService access$getIdentifierService$p(PresentationService $this) {
        return $this.identifierService;
    }

    public static final /* synthetic */ Object access$formAndSendResponse(PresentationService $this, PresentationResponse response, Identifier responder, Map requestedVcPresentationSubmissionMap, int expiryInSeconds, Continuation $completion) {
        return $this.formAndSendResponse(response, responder, requestedVcPresentationSubmissionMap, expiryInSeconds, (Continuation<? super Result<Unit>>)$completion);
    }
}

