/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk;

import android.util.Base64;
import com.microsoft.did.sdk.IdentifierService;
import com.microsoft.did.sdk.LinkedDomainsService;
import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.IssuanceRequest;
import com.microsoft.did.sdk.credential.service.IssuanceResponse;
import com.microsoft.did.sdk.credential.service.models.attestations.PresentationAttestation;
import com.microsoft.did.sdk.credential.service.models.contracts.VerifiableCredentialContract;
import com.microsoft.did.sdk.credential.service.models.issuancecallback.IssuanceCompletionResponse;
import com.microsoft.did.sdk.credential.service.models.linkedDomains.LinkedDomainResult;
import com.microsoft.did.sdk.credential.service.protectors.IssuanceResponseFormatter;
import com.microsoft.did.sdk.credential.service.validators.JwtValidator;
import com.microsoft.did.sdk.crypto.CryptoOperations;
import com.microsoft.did.sdk.crypto.DigestAlgorithm;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.datasource.network.credentialOperations.FetchContractNetworkOperation;
import com.microsoft.did.sdk.datasource.network.credentialOperations.SendIssuanceCompletionResponse;
import com.microsoft.did.sdk.datasource.network.credentialOperations.SendVerifiableCredentialIssuanceRequestNetworkOperation;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.microsoft.did.sdk.internal.ImageLoader;
import com.microsoft.did.sdk.util.controlflow.Result;
import com.microsoft.did.sdk.util.controlflow.ResultKt;
import com.microsoft.did.sdk.util.controlflow.RunResultTryContext;
import com.microsoft.did.sdk.util.log.SdkLog;
import java.security.SecureRandom;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016JI\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00180\u001ej\u0002` 2\b\b\u0002\u0010!\u001a\u00020\"H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0015H\u0002J\u0006\u0010&\u001a\u00020\u0015J\u001f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00122\u0006\u0010)\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J'\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00122\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcom/microsoft/did/sdk/IssuanceService;", "", "identifierService", "Lcom/microsoft/did/sdk/IdentifierService;", "linkedDomainsService", "Lcom/microsoft/did/sdk/LinkedDomainsService;", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "jwtValidator", "Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;", "issuanceResponseFormatter", "Lcom/microsoft/did/sdk/credential/service/protectors/IssuanceResponseFormatter;", "serializer", "Lkotlinx/serialization/json/Json;", "imageLoader", "Lcom/microsoft/did/sdk/internal/ImageLoader;", "(Lcom/microsoft/did/sdk/IdentifierService;Lcom/microsoft/did/sdk/LinkedDomainsService;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;Lcom/microsoft/did/sdk/credential/service/protectors/IssuanceResponseFormatter;Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/internal/ImageLoader;)V", "fetchContract", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "Lcom/microsoft/did/sdk/credential/service/models/contracts/VerifiableCredentialContract;", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "formAndSendResponse", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "response", "Lcom/microsoft/did/sdk/credential/service/IssuanceResponse;", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "requestedVcMap", "", "Lcom/microsoft/did/sdk/credential/service/models/attestations/PresentationAttestation;", "Lcom/microsoft/did/sdk/credential/service/RequestedVcMap;", "expiryInSeconds", "", "(Lcom/microsoft/did/sdk/credential/service/IssuanceResponse;Lcom/microsoft/did/sdk/identifier/models/Identifier;Ljava/util/Map;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateSecureRandomString", "getDidHash", "getNonce", "getRequest", "Lcom/microsoft/did/sdk/credential/service/IssuanceRequest;", "contractUrl", "sendCompletionResponse", "", "completionResponse", "Lcom/microsoft/did/sdk/credential/service/models/issuancecallback/IssuanceCompletionResponse;", "(Lcom/microsoft/did/sdk/credential/service/models/issuancecallback/IssuanceCompletionResponse;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendResponse", "(Lcom/microsoft/did/sdk/credential/service/IssuanceResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public final class IssuanceService {
    @NotNull
    private final IdentifierService identifierService;
    @NotNull
    private final LinkedDomainsService linkedDomainsService;
    @NotNull
    private final ApiProvider apiProvider;
    @NotNull
    private final JwtValidator jwtValidator;
    @NotNull
    private final IssuanceResponseFormatter issuanceResponseFormatter;
    @NotNull
    private final Json serializer;
    @NotNull
    private final ImageLoader imageLoader;

    @Inject
    public IssuanceService(@NotNull IdentifierService identifierService, @NotNull LinkedDomainsService linkedDomainsService, @NotNull ApiProvider apiProvider, @NotNull JwtValidator jwtValidator, @NotNull IssuanceResponseFormatter issuanceResponseFormatter, @NotNull Json serializer2, @NotNull ImageLoader imageLoader) {
        Intrinsics.checkNotNullParameter((Object)identifierService, (String)"identifierService");
        Intrinsics.checkNotNullParameter((Object)linkedDomainsService, (String)"linkedDomainsService");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)jwtValidator, (String)"jwtValidator");
        Intrinsics.checkNotNullParameter((Object)issuanceResponseFormatter, (String)"issuanceResponseFormatter");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        this.identifierService = identifierService;
        this.linkedDomainsService = linkedDomainsService;
        this.apiProvider = apiProvider;
        this.jwtValidator = jwtValidator;
        this.issuanceResponseFormatter = issuanceResponseFormatter;
        this.serializer = serializer2;
        this.imageLoader = imageLoader;
    }

    @Nullable
    public final Object getRequest(@NotNull String contractUrl, @NotNull Continuation<? super Result<IssuanceRequest>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends IssuanceRequest>>, Object>(this, contractUrl, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IssuanceService this$0;
            final /* synthetic */ String $contractUrl;
            {
                this.this$0 = $receiver;
                this.$contractUrl = $contractUrl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        var3_4 = "Issuance getRequest";
                        var4_5 = this.this$0;
                        var5_6 = this.$contractUrl;
                        $i$f$logTime = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-logTime-IssuanceService$getRequest$2$1 = false;
                        var10_16 = $this$runResultTry;
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = var10_16;
                        this.J$0 = start$iv;
                        this.label = 1;
                        v0 = IssuanceService.access$fetchContract(var4_5, var5_6, (Continuation)this);
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        var10_16 = (RunResultTryContext)this.L$4;
                        var5_6 = (String)this.L$3;
                        var4_5 = (IssuanceService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        contract = (VerifiableCredentialContract)var10_16.abortOnError((Result)v0);
                        var10_16 = $this$runResultTry;
                        this.L$0 = name$iv;
                        this.L$1 = var4_5;
                        this.L$2 = var5_6;
                        this.L$3 = var10_16;
                        this.L$4 = contract;
                        this.J$0 = start$iv;
                        this.label = 2;
                        v1 = IssuanceService.access$getLinkedDomainsService$p(var4_5).fetchAndVerifyLinkedDomains(contract.getInput().getIssuer(), (Continuation<? super Result<? extends LinkedDomainResult>>)this);
                        if (v1 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl59
                    }
                    case 2: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        contract = (VerifiableCredentialContract)this.L$4;
                        var10_16 = (RunResultTryContext)this.L$3;
                        var5_6 = (String)this.L$2;
                        var4_5 = (IssuanceService)this.L$1;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl59:
                        // 2 sources

                        linkedDomainResult = (LinkedDomainResult)var10_16.abortOnError((Result)v1);
                        request = new IssuanceRequest(contract, var5_6, linkedDomainResult);
                        this.L$0 = name$iv;
                        this.L$1 = request;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.J$0 = start$iv;
                        this.label = 3;
                        v2 = IssuanceService.access$getImageLoader$p(var4_5).loadRemoteImage(request, (Continuation<? super Unit>)this);
                        if (v2 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl80
                    }
                    case 3: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$getRequest$2$1 = false;
                        start$iv = this.J$0;
                        request = (IssuanceRequest)this.L$1;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl80:
                        // 2 sources

                        result$iv = new Result.Success<IssuanceRequest>(request);
                        elapsedTime$iv = System.currentTimeMillis() - start$iv;
                        var11_22 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv))};
                        SdkLog.INSTANCE.event("DIDPerformanceMetrics", MapsKt.mapOf((Pair[])var11_22));
                        return result$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<RunResultTryContext, Continuation<? super Result<? extends IssuanceRequest>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<IssuanceRequest>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Object fetchContract(String url, Continuation<? super Result<VerifiableCredentialContract>> $completion) {
        return new FetchContractNetworkOperation(url, this.apiProvider, this.jwtValidator, this.serializer).fire($completion);
    }

    @NotNull
    public final String getNonce() {
        return this.generateSecureRandomString() + '.' + this.getDidHash();
    }

    private final String getDidHash() {
        String did2;
        String string = did2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
            int label;
            final /* synthetic */ IssuanceService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = IssuanceService.access$getIdentifierService$p(this.this$0).getMasterIdentifier((Continuation<? super Result<Identifier>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((result = (Result)v0) instanceof Result.Success) {
                            v1 = ((Identifier)((Result.Success)result).getPayload()).getId();
                        } else if (result instanceof Result.Failure) {
                            SdkLog.e$default(SdkLog.INSTANCE, "Could not get DID", ((Result.Failure)result).getPayload(), null, 4, null);
                            v1 = "";
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] digest = CryptoOperations.INSTANCE.digest(byArray, DigestAlgorithm.Sha512.INSTANCE);
        String string2 = Base64.encodeToString((byte[])digest, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(digest, Constants.BASE64_URL_SAFE)");
        return string2;
    }

    private final String generateSecureRandomString() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        String string = Base64.encodeToString((byte[])bytes, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(bytes, Constants.BASE64_URL_SAFE)");
        return string;
    }

    @Nullable
    public final Object sendResponse(@NotNull IssuanceResponse response, @NotNull Continuation<? super Result<VerifiableCredential>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends VerifiableCredential>>, Object>(this, response, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IssuanceService this$0;
            final /* synthetic */ IssuanceResponse $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        var3_4 = "Issuance sendResponse";
                        var4_5 = this.this$0;
                        var5_6 = this.$response;
                        $i$f$logTime = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-logTime-IssuanceService$sendResponse$2$1 = false;
                        var10_14 = $this$runResultTry;
                        this.L$0 = $this$runResultTry;
                        this.L$1 = name$iv;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = var10_14;
                        this.J$0 = start$iv;
                        this.label = 1;
                        v0 = IssuanceService.access$getIdentifierService$p(var4_5).getMasterIdentifier((Continuation<? super Result<Identifier>>)this);
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$sendResponse$2$1 = false;
                        start$iv = this.J$0;
                        var10_14 = (RunResultTryContext)this.L$4;
                        var5_6 = (IssuanceResponse)this.L$3;
                        var4_5 = (IssuanceService)this.L$2;
                        name$iv = (String)this.L$1;
                        $this$runResultTry = (RunResultTryContext)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        masterIdentifier = (Identifier)var10_14.abortOnError((Result)v0);
                        requestedVcMap = var5_6.getRequestedVcMap();
                        var10_14 = $this$runResultTry;
                        this.L$0 = name$iv;
                        this.L$1 = var10_14;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.L$4 = null;
                        this.J$0 = start$iv;
                        this.label = 2;
                        v1 = IssuanceService.formAndSendResponse$default(var4_5, var5_6, masterIdentifier, requestedVcMap, 0, (Continuation)this, 8, null);
                        if (v1 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl57
                    }
                    case 2: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$sendResponse$2$1 = false;
                        start$iv = this.J$0;
                        var10_14 = (RunResultTryContext)this.L$1;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl57:
                        // 2 sources

                        verifiableCredential = (VerifiableCredential)var10_14.abortOnError((Result)v1);
                        result$iv = new Result.Success<VerifiableCredential>(verifiableCredential);
                        elapsedTime$iv = System.currentTimeMillis() - start$iv;
                        var11_20 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv))};
                        SdkLog.INSTANCE.event("DIDPerformanceMetrics", MapsKt.mapOf((Pair[])var11_20));
                        return result$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<RunResultTryContext, Continuation<? super Result<? extends VerifiableCredential>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<VerifiableCredential>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object sendCompletionResponse(@NotNull IssuanceCompletionResponse completionResponse, @NotNull String url, @NotNull Continuation<? super Result<Unit>> $completion) {
        return ResultKt.runResultTry((Function2)new Function2<RunResultTryContext, Continuation<? super Result<? extends Unit>>, Object>(url, this, completionResponse, null){
            Object L$0;
            long J$0;
            int label;
            final /* synthetic */ String $url;
            final /* synthetic */ IssuanceService this$0;
            final /* synthetic */ IssuanceCompletionResponse $completionResponse;
            {
                this.$url = $url;
                this.this$0 = $receiver;
                this.$completionResponse = $completionResponse;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        kotlin.ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = "Issuance sendCompletionResponse";
                        var3_4 = this.$url;
                        var4_5 = this.this$0;
                        var5_6 = this.$completionResponse;
                        $i$f$logTime = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-logTime-IssuanceService$sendCompletionResponse$2$1 = false;
                        $this$encodeToString$iv = (StringFormat)IssuanceService.access$getSerializer$p(var4_5);
                        $i$f$encodeToString = false;
                        $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                        $i$f$serializer = false;
                        $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(IssuanceCompletionResponse.class));
                        $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        this.L$0 = name$iv;
                        this.J$0 = start$iv;
                        this.label = 1;
                        v0 = new SendIssuanceCompletionResponse(var3_4, $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)var5_6), IssuanceService.access$getApiProvider$p(var4_5)).fire(this);
                        if (v0 == var19_2) {
                            return var19_2;
                        }
                        ** GOTO lbl34
                    }
                    case 1: {
                        $i$f$logTime = false;
                        $i$a$-logTime-IssuanceService$sendCompletionResponse$2$1 = false;
                        start$iv = this.J$0;
                        name$iv = (String)this.L$0;
                        kotlin.ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 2 sources

                        result$iv = (Result)v0;
                        elapsedTime$iv = System.currentTimeMillis() - start$iv;
                        var11_14 = new Pair[]{TuplesKt.to((Object)"eventName", (Object)name$iv), TuplesKt.to((Object)"duration_ms", (Object)String.valueOf(elapsedTime$iv))};
                        SdkLog.INSTANCE.event("DIDPerformanceMetrics", MapsKt.mapOf((Pair[])var11_14));
                        return result$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull RunResultTryContext p1, @Nullable Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Object formAndSendResponse(IssuanceResponse response, Identifier responder, Map<PresentationAttestation, VerifiableCredential> requestedVcMap, int expiryInSeconds, Continuation<? super Result<VerifiableCredential>> $completion) {
        String formattedResponse = this.issuanceResponseFormatter.formatResponse(requestedVcMap, response, responder, expiryInSeconds);
        return new SendVerifiableCredentialIssuanceRequestNetworkOperation(response.getAudience(), formattedResponse, this.apiProvider, this.jwtValidator, this.serializer).fire($completion);
    }

    static /* synthetic */ Object formAndSendResponse$default(IssuanceService issuanceService, IssuanceResponse issuanceResponse, Identifier identifier, Map map, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 3600;
        }
        return issuanceService.formAndSendResponse(issuanceResponse, identifier, map, n, (Continuation<? super Result<VerifiableCredential>>)continuation);
    }

    public static final /* synthetic */ Object access$fetchContract(IssuanceService $this, String url, Continuation $completion) {
        return $this.fetchContract(url, (Continuation<? super Result<VerifiableCredentialContract>>)$completion);
    }

    public static final /* synthetic */ LinkedDomainsService access$getLinkedDomainsService$p(IssuanceService $this) {
        return $this.linkedDomainsService;
    }

    public static final /* synthetic */ ImageLoader access$getImageLoader$p(IssuanceService $this) {
        return $this.imageLoader;
    }

    public static final /* synthetic */ IdentifierService access$getIdentifierService$p(IssuanceService $this) {
        return $this.identifierService;
    }

    public static final /* synthetic */ Json access$getSerializer$p(IssuanceService $this) {
        return $this.serializer;
    }

    public static final /* synthetic */ ApiProvider access$getApiProvider$p(IssuanceService $this) {
        return $this.apiProvider;
    }

    public static final /* synthetic */ Object access$formAndSendResponse(IssuanceService $this, IssuanceResponse response, Identifier responder, Map requestedVcMap, int expiryInSeconds, Continuation $completion) {
        return $this.formAndSendResponse(response, responder, requestedVcMap, expiryInSeconds, (Continuation<? super Result<VerifiableCredential>>)$completion);
    }
}

