/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.util;

import com.microsoft.did.sdk.util.log.SdkLog;
import com.microsoft.walletlibrary.util.WalletLibraryLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u0016J*\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/microsoft/walletlibrary/util/WalletLibraryVCSDKLogConsumer;", "Lcom/microsoft/did/sdk/util/log/SdkLog$Consumer;", "logger", "Lcom/microsoft/walletlibrary/util/WalletLibraryLogger;", "(Lcom/microsoft/walletlibrary/util/WalletLibraryLogger;)V", "event", "", "name", "", "properties", "", "log", "logLevel", "Lcom/microsoft/did/sdk/util/log/SdkLog$Level;", "message", "throwable", "", "tag", "mapVcLogLevelToWalletLibraryLogLevel", "Lcom/microsoft/walletlibrary/util/WalletLibraryLogger$Level;", "walletlibrary_release"})
public final class WalletLibraryVCSDKLogConsumer
implements SdkLog.Consumer {
    @NotNull
    private final WalletLibraryLogger logger;

    public WalletLibraryVCSDKLogConsumer(@NotNull WalletLibraryLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    public void log(@NotNull SdkLog.Level logLevel, @NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.logger.log(this.mapVcLogLevelToWalletLibraryLogLevel(logLevel), message, throwable, tag);
    }

    @Override
    public void event(@NotNull String name, @Nullable Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.logger.event(name, properties);
    }

    private final WalletLibraryLogger.Level mapVcLogLevelToWalletLibraryLogLevel(SdkLog.Level logLevel) {
        WalletLibraryLogger.Level level;
        switch (WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
            case 1: {
                level = WalletLibraryLogger.Level.VERBOSE;
                break;
            }
            case 2: {
                level = WalletLibraryLogger.Level.DEBUG;
                break;
            }
            case 3: {
                level = WalletLibraryLogger.Level.INFO;
                break;
            }
            case 4: {
                level = WalletLibraryLogger.Level.WARN;
                break;
            }
            case 5: {
                level = WalletLibraryLogger.Level.ERROR;
                break;
            }
            case 6: {
                level = WalletLibraryLogger.Level.FAILURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SdkLog.Level.values().length];
            nArray[SdkLog.Level.VERBOSE.ordinal()] = 1;
            nArray[SdkLog.Level.DEBUG.ordinal()] = 2;
            nArray[SdkLog.Level.INFO.ordinal()] = 3;
            nArray[SdkLog.Level.WARN.ordinal()] = 4;
            nArray[SdkLog.Level.ERROR.ordinal()] = 5;
            nArray[SdkLog.Level.FAILURE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

