/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.requests.handlers;

import com.microsoft.walletlibrary.mappings.issuance.DisplayContractMappingKt;
import com.microsoft.walletlibrary.requests.ManifestIssuanceRequest;
import com.microsoft.walletlibrary.requests.OpenIdPresentationRequest;
import com.microsoft.walletlibrary.requests.PresentationRequestContent;
import com.microsoft.walletlibrary.requests.VerifiedIdRequest;
import com.microsoft.walletlibrary.requests.handlers.OpenIdRequestHandler;
import com.microsoft.walletlibrary.requests.handlers.RequestHandler;
import com.microsoft.walletlibrary.requests.input.VerifiedIdRequestURL;
import com.microsoft.walletlibrary.requests.rawrequests.OpenIdRawRequest;
import com.microsoft.walletlibrary.requests.rawrequests.RawManifest;
import com.microsoft.walletlibrary.requests.rawrequests.RawRequest;
import com.microsoft.walletlibrary.requests.rawrequests.RequestType;
import com.microsoft.walletlibrary.requests.requirements.Requirement;
import com.microsoft.walletlibrary.requests.requirements.VerifiedIdRequirement;
import com.microsoft.walletlibrary.util.InputCastingException;
import com.microsoft.walletlibrary.util.RequirementCastingException;
import com.microsoft.walletlibrary.util.UnSupportedProtocolException;
import com.microsoft.walletlibrary.verifiedid.VerifiedId;
import com.microsoft.walletlibrary.wrapper.ManifestResolver;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001d\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0012\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/walletlibrary/requests/handlers/OpenIdRequestHandler;", "Lcom/microsoft/walletlibrary/requests/handlers/RequestHandler;", "()V", "getIssuanceRequest", "Lcom/microsoft/walletlibrary/requests/rawrequests/RawManifest;", "contractUrl", "", "requestState", "issuanceCallbackUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleIssuanceRequest", "Lcom/microsoft/walletlibrary/requests/VerifiedIdRequest;", "Lcom/microsoft/walletlibrary/verifiedid/VerifiedId;", "presentationRequestContent", "Lcom/microsoft/walletlibrary/requests/PresentationRequestContent;", "(Lcom/microsoft/walletlibrary/requests/PresentationRequestContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handlePresentationRequest", "", "rawRequest", "Lcom/microsoft/walletlibrary/requests/rawrequests/OpenIdRawRequest;", "handleRequest", "Lcom/microsoft/walletlibrary/requests/rawrequests/RawRequest;", "(Lcom/microsoft/walletlibrary/requests/rawrequests/RawRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateRequirement", "requestContent", "walletlibrary_release"})
public final class OpenIdRequestHandler
implements RequestHandler {
    @Override
    @Nullable
    public Object handleRequest(@NotNull RawRequest rawRequest, @NotNull Continuation<? super VerifiedIdRequest<?>> $completion) {
        if (!(rawRequest instanceof OpenIdRawRequest)) {
            throw new UnSupportedProtocolException("Received a raw request of unsupported protocol", null, false, 6, null);
        }
        PresentationRequestContent presentationRequestContent = ((OpenIdRawRequest)rawRequest).mapToPresentationRequestContent();
        if (rawRequest.getRequestType() == RequestType.ISSUANCE) {
            return this.handleIssuanceRequest(presentationRequestContent, $completion);
        }
        return this.handlePresentationRequest(presentationRequestContent, (OpenIdRawRequest)rawRequest);
    }

    private final VerifiedIdRequest<Unit> handlePresentationRequest(PresentationRequestContent presentationRequestContent, OpenIdRawRequest rawRequest) {
        return new OpenIdPresentationRequest(presentationRequestContent.getRequesterStyle$walletlibrary_release(), presentationRequestContent.getRequirement$walletlibrary_release(), presentationRequestContent.getRootOfTrust$walletlibrary_release(), rawRequest);
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleIssuanceRequest(PresentationRequestContent var1_1, Continuation<? super VerifiedIdRequest<? extends VerifiedId>> var2_2) {
        if (!(var2_2 instanceof handleIssuanceRequest.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ OpenIdRequestHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenIdRequestHandler.access$handleIssuanceRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.validateRequirement(presentationRequestContent);
                v0 = presentationRequestContent.getRequirement$walletlibrary_release();
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.requirements.VerifiedIdRequirement");
                v1 = CollectionsKt.first(((VerifiedIdRequirement)v0).getIssuanceOptions());
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.input.VerifiedIdRequestURL");
                contractUrl = ((VerifiedIdRequestURL)v1).getUrl$walletlibrary_release();
                var5_7 = contractUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"contractUrl.toString()");
                $continuation.L$0 = presentationRequestContent;
                $continuation.label = 1;
                v2 = this.getIssuanceRequest(var5_7, presentationRequestContent.getRequestState$walletlibrary_release(), presentationRequestContent.getIssuanceCallbackUrl$walletlibrary_release(), (Continuation<? super RawManifest>)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                presentationRequestContent = (PresentationRequestContent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl30:
                // 2 sources

                rawManifest = (RawManifest)v2;
                issuanceRequestContent = rawManifest.mapToIssuanceRequestContent$walletlibrary_release();
                v3 = presentationRequestContent.getInjectedIdToken$walletlibrary_release();
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-OpenIdRequestHandler$handleIssuanceRequest$2 = false;
                    issuanceRequestContent.addRequirementsForIdTokenHint$walletlibrary_release(it);
                }
                return new ManifestIssuanceRequest(issuanceRequestContent.getRequesterStyle$walletlibrary_release(), issuanceRequestContent.getRequirement$walletlibrary_release(), issuanceRequestContent.getRootOfTrust$walletlibrary_release(), DisplayContractMappingKt.toVerifiedIdStyle(rawManifest.getRawRequest().getContract().getDisplay()), rawManifest, presentationRequestContent.getIssuanceCallbackUrl$walletlibrary_release(), presentationRequestContent.getRequestState$walletlibrary_release());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void validateRequirement(PresentationRequestContent requestContent) {
        if (!(requestContent.getRequirement$walletlibrary_release() instanceof VerifiedIdRequirement)) {
            throw new RequirementCastingException("Requirement is not the expected VerifiedId Requirement", null, false, 6, null);
        }
        Requirement requirement = requestContent.getRequirement$walletlibrary_release();
        Intrinsics.checkNotNull((Object)requirement, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.requirements.VerifiedIdRequirement");
        if (!(CollectionsKt.first(((VerifiedIdRequirement)requirement).getIssuanceOptions()) instanceof VerifiedIdRequestURL)) {
            throw new InputCastingException("VerifiedId Input is not the expected VerifiedIdRequestURL type", null, false, 6, null);
        }
    }

    private final Object getIssuanceRequest(String contractUrl, String requestState, String issuanceCallbackUrl, Continuation<? super RawManifest> $completion) {
        return ManifestResolver.INSTANCE.getIssuanceRequest(contractUrl, requestState, issuanceCallbackUrl, $completion);
    }

    public static final /* synthetic */ Object access$handleIssuanceRequest(OpenIdRequestHandler $this, PresentationRequestContent presentationRequestContent, Continuation $completion) {
        return $this.handleIssuanceRequest(presentationRequestContent, (Continuation<? super VerifiedIdRequest<? extends VerifiedId>>)$completion);
    }

    public static final /* synthetic */ Object access$getIssuanceRequest(OpenIdRequestHandler $this, String contractUrl, String requestState, String issuanceCallbackUrl, Continuation $completion) {
        return $this.getIssuanceRequest(contractUrl, requestState, issuanceCallbackUrl, (Continuation<? super RawManifest>)$completion);
    }
}

