/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.walletlibrary.requests;

import com.microsoft.walletlibrary.requests.InjectedIdToken;
import com.microsoft.walletlibrary.requests.RootOfTrust;
import com.microsoft.walletlibrary.requests.requirements.GroupRequirement;
import com.microsoft.walletlibrary.requests.requirements.GroupRequirementOperator;
import com.microsoft.walletlibrary.requests.requirements.IdTokenRequirement;
import com.microsoft.walletlibrary.requests.requirements.PinRequirement;
import com.microsoft.walletlibrary.requests.requirements.Requirement;
import com.microsoft.walletlibrary.requests.styles.RequesterStyle;
import com.microsoft.walletlibrary.requests.styles.VerifiedIdStyle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/microsoft/walletlibrary/requests/IssuanceRequestContent;", "", "requesterStyle", "Lcom/microsoft/walletlibrary/requests/styles/RequesterStyle;", "requirement", "Lcom/microsoft/walletlibrary/requests/requirements/Requirement;", "rootOfTrust", "Lcom/microsoft/walletlibrary/requests/RootOfTrust;", "verifiedIDStyle", "Lcom/microsoft/walletlibrary/requests/styles/VerifiedIdStyle;", "(Lcom/microsoft/walletlibrary/requests/styles/RequesterStyle;Lcom/microsoft/walletlibrary/requests/requirements/Requirement;Lcom/microsoft/walletlibrary/requests/RootOfTrust;Lcom/microsoft/walletlibrary/requests/styles/VerifiedIdStyle;)V", "getRequesterStyle$walletlibrary_release", "()Lcom/microsoft/walletlibrary/requests/styles/RequesterStyle;", "getRequirement$walletlibrary_release", "()Lcom/microsoft/walletlibrary/requests/requirements/Requirement;", "setRequirement$walletlibrary_release", "(Lcom/microsoft/walletlibrary/requests/requirements/Requirement;)V", "getRootOfTrust$walletlibrary_release", "()Lcom/microsoft/walletlibrary/requests/RootOfTrust;", "getVerifiedIDStyle$walletlibrary_release", "()Lcom/microsoft/walletlibrary/requests/styles/VerifiedIdStyle;", "addRequirementsForIdTokenHint", "", "idToken", "Lcom/microsoft/walletlibrary/requests/InjectedIdToken;", "addRequirementsForIdTokenHint$walletlibrary_release", "addRequirementsForIdTokenHintToGroupRequirement", "fulfillIdTokenRequirement", "idTokenRequirement", "Lcom/microsoft/walletlibrary/requests/requirements/IdTokenRequirement;", "groupRequirement", "Lcom/microsoft/walletlibrary/requests/requirements/GroupRequirement;", "walletlibrary_release"})
public final class IssuanceRequestContent {
    @NotNull
    private final RequesterStyle requesterStyle;
    @NotNull
    private Requirement requirement;
    @NotNull
    private final RootOfTrust rootOfTrust;
    @NotNull
    private final VerifiedIdStyle verifiedIDStyle;

    public IssuanceRequestContent(@NotNull RequesterStyle requesterStyle, @NotNull Requirement requirement, @NotNull RootOfTrust rootOfTrust, @NotNull VerifiedIdStyle verifiedIDStyle) {
        Intrinsics.checkNotNullParameter((Object)requesterStyle, (String)"requesterStyle");
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
        Intrinsics.checkNotNullParameter((Object)rootOfTrust, (String)"rootOfTrust");
        Intrinsics.checkNotNullParameter((Object)verifiedIDStyle, (String)"verifiedIDStyle");
        this.requesterStyle = requesterStyle;
        this.requirement = requirement;
        this.rootOfTrust = rootOfTrust;
        this.verifiedIDStyle = verifiedIDStyle;
    }

    @NotNull
    public final RequesterStyle getRequesterStyle$walletlibrary_release() {
        return this.requesterStyle;
    }

    @NotNull
    public final Requirement getRequirement$walletlibrary_release() {
        return this.requirement;
    }

    public final void setRequirement$walletlibrary_release(@NotNull Requirement requirement) {
        Intrinsics.checkNotNullParameter((Object)requirement, (String)"<set-?>");
        this.requirement = requirement;
    }

    @NotNull
    public final RootOfTrust getRootOfTrust$walletlibrary_release() {
        return this.rootOfTrust;
    }

    @NotNull
    public final VerifiedIdStyle getVerifiedIDStyle$walletlibrary_release() {
        return this.verifiedIDStyle;
    }

    public final void addRequirementsForIdTokenHint$walletlibrary_release(@NotNull InjectedIdToken idToken) {
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        Requirement requirement = this.requirement;
        if (requirement instanceof IdTokenRequirement) {
            Object[] objectArray = new Requirement[]{this.requirement};
            GroupRequirement groupRequirement = new GroupRequirement(false, CollectionsKt.mutableListOf((Object[])objectArray), GroupRequirementOperator.ALL);
            Requirement requirement2 = this.requirement;
            Intrinsics.checkNotNull((Object)requirement2, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.requirements.IdTokenRequirement");
            this.fulfillIdTokenRequirement((IdTokenRequirement)requirement2, idToken, groupRequirement);
            this.requirement = groupRequirement;
        } else if (requirement instanceof GroupRequirement) {
            this.addRequirementsForIdTokenHintToGroupRequirement(idToken);
        }
    }

    private final void addRequirementsForIdTokenHintToGroupRequirement(InjectedIdToken idToken) {
        if (this.requirement instanceof GroupRequirement) {
            Requirement requirement = this.requirement;
            Intrinsics.checkNotNull((Object)requirement, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.requirements.GroupRequirement");
            List<Requirement> requirementsInGroup = ((GroupRequirement)requirement).getRequirements();
            for (Requirement requirementInGroup : requirementsInGroup) {
                if (!(requirementInGroup instanceof IdTokenRequirement) || !Intrinsics.areEqual((Object)((IdTokenRequirement)requirementInGroup).getConfiguration(), (Object)"https://self-issued.me")) continue;
                IdTokenRequirement idTokenRequirement = (IdTokenRequirement)requirementInGroup;
                Requirement requirement2 = this.requirement;
                Intrinsics.checkNotNull((Object)requirement2, (String)"null cannot be cast to non-null type com.microsoft.walletlibrary.requests.requirements.GroupRequirement");
                this.fulfillIdTokenRequirement(idTokenRequirement, idToken, (GroupRequirement)requirement2);
            }
        }
    }

    private final void fulfillIdTokenRequirement(IdTokenRequirement idTokenRequirement, InjectedIdToken idToken, GroupRequirement groupRequirement) {
        block0: {
            idTokenRequirement.fulfill(idToken.getRawToken$walletlibrary_release());
            PinRequirement pinRequirement = idToken.getPinRequirement$walletlibrary_release();
            if (pinRequirement == null) break block0;
            PinRequirement it = pinRequirement;
            boolean bl = false;
            groupRequirement.getRequirements().add(it);
        }
    }
}

