/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.util.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fJ$\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fJ&\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001cJ$\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fJ%\u0010\u001e\u001a\u0004\u0018\u00010\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 2\u0006\u0010!\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fJ\b\u0010$\u001a\u00020\u000fH\u0002J,\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J$\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fJ$\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/microsoft/did/sdk/util/log/SdkLog;", "", "()V", "ANONYMOUS_CLASS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CONSUMERS", "", "Lcom/microsoft/did/sdk/util/log/SdkLog$Consumer;", "ORIGINAL_CALLER_STACK_INDEX", "", "addConsumer", "", "consumer", "createStackElementTag", "", "element", "Ljava/lang/StackTraceElement;", "d", "", "message", "throwable", "", "tag", "e", "event", "name", "properties", "", "f", "getCallerElement", "stackTrace", "", "index", "([Ljava/lang/StackTraceElement;I)Ljava/lang/StackTraceElement;", "i", "implicitTag", "log", "logLevel", "Lcom/microsoft/did/sdk/util/log/SdkLog$Level;", "v", "w", "Consumer", "Level", "walletlibrary_release"})
public final class SdkLog {
    @NotNull
    public static final SdkLog INSTANCE = new SdkLog();
    private static final int ORIGINAL_CALLER_STACK_INDEX = 2;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");
    @NotNull
    private static final List<Consumer> CONSUMERS = new ArrayList();

    private SdkLog() {
    }

    public final boolean addConsumer(@NotNull Consumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return CONSUMERS.add(consumer);
    }

    public final void event(@NotNull String name, @Nullable Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$forEach$iv = CONSUMERS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.event(name, properties);
        }
    }

    public static /* synthetic */ void event$default(SdkLog sdkLog, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        sdkLog.event(string, map);
    }

    public final void v(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.VERBOSE, message, throwable, tag);
    }

    public static /* synthetic */ void v$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.v(string, throwable, string2);
    }

    public final void d(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.DEBUG, message, throwable, tag);
    }

    public static /* synthetic */ void d$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.d(string, throwable, string2);
    }

    public final void i(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.INFO, message, throwable, tag);
    }

    public static /* synthetic */ void i$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.i(string, throwable, string2);
    }

    public final void w(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.WARN, message, throwable, tag);
    }

    public static /* synthetic */ void w$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.w(string, throwable, string2);
    }

    public final void e(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.ERROR, message, throwable, tag);
    }

    public static /* synthetic */ void e$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.e(string, throwable, string2);
    }

    public final void f(@NotNull String message, @Nullable Throwable throwable, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.log(Level.FAILURE, message, throwable, tag);
    }

    public static /* synthetic */ void f$default(SdkLog sdkLog, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            string2 = sdkLog.implicitTag();
        }
        sdkLog.f(string, throwable, string2);
    }

    private final void log(Level logLevel, String message, Throwable throwable, String tag) {
        Iterable $this$forEach$iv = CONSUMERS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.log(logLevel, message, throwable, tag);
        }
    }

    static /* synthetic */ void log$default(SdkLog sdkLog, Level level, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            throwable = null;
        }
        sdkLog.log(level, string, throwable, string2);
    }

    private final String implicitTag() {
        StackTraceElement stackElement;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Throwable().stackTrace");
        StackTraceElement stackTraceElement = stackElement = this.getCallerElement(stackTraceElementArray, 2);
        return stackTraceElement != null ? this.createStackElementTag(stackTraceElement) : "INVALID_TAG";
    }

    private final StackTraceElement getCallerElement(StackTraceElement[] stackTrace, int index) {
        if (stackTrace.length <= index) {
            this.w("Synthetic stacktrace didn't have enough elements: are you using proguard?", null, "SdkLog.implicitTag");
            return null;
        }
        if (Intrinsics.areEqual((Object)stackTrace[index].getClassName(), (Object)this.getClass().getName()) && stackTrace[index].getMethodName().length() == 1 && stackTrace.length > index + 1) {
            return stackTrace[index + 1];
        }
        return stackTrace[index];
    }

    private final String createStackElementTag(StackTraceElement element) {
        Matcher matcher = ANONYMOUS_CLASS.matcher(element.getClassName());
        String tag = matcher.find() ? matcher.replaceAll("") + "$ANON$" : element.getClassName();
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        String string = tag.substring(StringsKt.lastIndexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return stringBuilder.append(string).append('.').append(element.getMethodName()).toString();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007H&J,\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H&\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/did/sdk/util/log/SdkLog$Consumer;", "", "event", "", "name", "", "properties", "", "log", "logLevel", "Lcom/microsoft/did/sdk/util/log/SdkLog$Level;", "message", "throwable", "", "tag", "walletlibrary_release"})
    public static interface Consumer {
        public void log(@NotNull Level var1, @NotNull String var2, @Nullable Throwable var3, @NotNull String var4);

        public void event(@NotNull String var1, @Nullable Map<String, String> var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void log$default(Consumer consumer, Level level, String string, Throwable throwable, String string2, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
                }
                if ((n & 4) != 0) {
                    throwable = null;
                }
                consumer.log(level, string, throwable, string2);
            }

            public static /* synthetic */ void event$default(Consumer consumer, String string, Map map, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: event");
                }
                if ((n & 2) != 0) {
                    map = null;
                }
                consumer.event(string, map);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/microsoft/did/sdk/util/log/SdkLog$Level;", "", "(Ljava/lang/String;I)V", "severity", "", "VERBOSE", "DEBUG", "INFO", "WARN", "ERROR", "FAILURE", "walletlibrary_release"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level VERBOSE = new Level();
        public static final /* enum */ Level DEBUG = new Level();
        public static final /* enum */ Level INFO = new Level();
        public static final /* enum */ Level WARN = new Level();
        public static final /* enum */ Level ERROR = new Level();
        public static final /* enum */ Level FAILURE = new Level();
        private static final /* synthetic */ Level[] $VALUES;

        public final int severity() {
            return this.ordinal();
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        static {
            $VALUES = levelArray = new Level[]{Level.VERBOSE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FAILURE};
        }
    }
}

