/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.identifier;

import android.util.Base64;
import com.microsoft.did.sdk.crypto.CryptoOperations;
import com.microsoft.did.sdk.crypto.DigestAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.erdtman.jcs.JsonCanonicalizer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/microsoft/did/sdk/identifier/SideTreeHelper;", "", "()V", "canonicalizeAndDoubleMultiHash", "", "json", "canonicalizeMultiHashEncode", "createCommitmentValue", "key", "Lcom/nimbusds/jose/jwk/JWK;", "prependMultiHashInfo", "", "bytes", "walletlibrary_release"})
public final class SideTreeHelper {
    @Inject
    public SideTreeHelper() {
    }

    @NotNull
    public final String canonicalizeMultiHashEncode(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonCanonicalizer jsonCanonicalizer = new JsonCanonicalizer(json);
        byte[] byArray = jsonCanonicalizer.getEncodedUTF8();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jsonCanonicalizer.encodedUTF8");
        byte[] hashed = CryptoOperations.INSTANCE.digest(byArray, DigestAlgorithm.Sha256.INSTANCE);
        byte[] hashedWithMultiHashInfo = this.prependMultiHashInfo(hashed);
        String string = Base64.encodeToString((byte[])hashedWithMultiHashInfo, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(hashedWit\u2026onstants.BASE64_URL_SAFE)");
        return string;
    }

    @NotNull
    public final String createCommitmentValue(@NotNull JWK key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.toJSONString()");
        return this.canonicalizeAndDoubleMultiHash(string);
    }

    private final String canonicalizeAndDoubleMultiHash(String json) {
        JsonCanonicalizer jsonCanonicalizer = new JsonCanonicalizer(json);
        byte[] byArray = jsonCanonicalizer.getEncodedUTF8();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jsonCanonicalizer.encodedUTF8");
        byte[] hashed = CryptoOperations.INSTANCE.digest(byArray, DigestAlgorithm.Sha256.INSTANCE);
        byte[] doubleHashed = CryptoOperations.INSTANCE.digest(hashed, DigestAlgorithm.Sha256.INSTANCE);
        byte[] doubleHashedWithMultiHashInfo = this.prependMultiHashInfo(doubleHashed);
        String string = Base64.encodeToString((byte[])doubleHashedWithMultiHashInfo, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(doubleHas\u2026onstants.BASE64_URL_SAFE)");
        return string;
    }

    private final byte[] prependMultiHashInfo(byte[] bytes) {
        byte[] byArray = new byte[]{18, 32};
        return ArraysKt.plus((byte[])byArray, (byte[])bytes);
    }
}

