/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.repository;

import com.microsoft.did.sdk.datasource.db.SdkDatabase;
import com.microsoft.did.sdk.datasource.db.dao.IdentifierDao;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.datasource.network.identifierOperations.ResolveIdentifierNetworkOperation;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.microsoft.did.sdk.identifier.models.identifierdocument.IdentifierResponse;
import com.microsoft.did.sdk.util.controlflow.Result;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J'\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/did/sdk/datasource/repository/IdentifierRepository;", "", "database", "Lcom/microsoft/did/sdk/datasource/db/SdkDatabase;", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "(Lcom/microsoft/did/sdk/datasource/db/SdkDatabase;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;)V", "getApiProvider", "()Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "identifierDao", "Lcom/microsoft/did/sdk/datasource/db/dao/IdentifierDao;", "deleteAll", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteIdentifier", "identifier", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insert", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "(Lcom/microsoft/did/sdk/identifier/models/Identifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllLocal", "", "queryByIdentifier", "queryByName", "name", "resolveIdentifier", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "Lcom/microsoft/did/sdk/identifier/models/identifierdocument/IdentifierResponse;", "url", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public final class IdentifierRepository {
    @NotNull
    private final ApiProvider apiProvider;
    @NotNull
    private final IdentifierDao identifierDao;

    @Inject
    public IdentifierRepository(@NotNull SdkDatabase database, @NotNull ApiProvider apiProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        this.apiProvider = apiProvider;
        this.identifierDao = database.identifierDao();
    }

    @NotNull
    public final ApiProvider getApiProvider() {
        return this.apiProvider;
    }

    @Nullable
    public final Object resolveIdentifier(@NotNull String url, @NotNull String identifier, @NotNull Continuation<? super Result<IdentifierResponse>> $completion) {
        return new ResolveIdentifierNetworkOperation(this.apiProvider, url, identifier).fire($completion);
    }

    @Nullable
    public final Object insert(@NotNull Identifier identifier, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.identifierDao.insert(identifier, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object queryByIdentifier(@NotNull String identifier, @NotNull Continuation<? super Identifier> $completion) {
        return this.identifierDao.queryByIdentifier(identifier, $completion);
    }

    @Nullable
    public final Object queryByName(@NotNull String name, @NotNull Continuation<? super Identifier> $completion) {
        return this.identifierDao.queryByName(name, $completion);
    }

    @Nullable
    public final Object queryAllLocal(@NotNull Continuation<? super List<Identifier>> $completion) {
        return this.identifierDao.queryAllLocal($completion);
    }

    @Nullable
    public final Object deleteIdentifier(@NotNull String identifier, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.identifierDao.deleteIdentifier(identifier, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object deleteAll(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.identifierDao.deleteAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

