/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.network.credentialOperations;

import com.microsoft.did.sdk.credential.models.RevocationReceipt;
import com.microsoft.did.sdk.credential.service.models.serviceResponses.RevocationServiceResponse;
import com.microsoft.did.sdk.crypto.protocols.jose.jws.JwsToken;
import com.microsoft.did.sdk.datasource.network.PostNetworkOperation;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.util.controlflow.Result;
import com.microsoft.did.sdk.util.controlflow.RevocationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR5\u0010\f\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\rX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/microsoft/did/sdk/datasource/network/credentialOperations/SendVerifiablePresentationRevocationRequestNetworkOperation;", "Lcom/microsoft/did/sdk/datasource/network/PostNetworkOperation;", "Lcom/microsoft/did/sdk/credential/service/models/serviceResponses/RevocationServiceResponse;", "Lcom/microsoft/did/sdk/credential/models/RevocationReceipt;", "url", "", "serializedResponse", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "serializer", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/String;Ljava/lang/String;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;Lkotlinx/serialization/json/Json;)V", "call", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lretrofit2/Response;", "", "getCall", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "onSuccess", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "response", "(Lretrofit2/Response;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unwrapRevocationReceipt", "signedReceipt", "walletlibrary_release"})
public final class SendVerifiablePresentationRevocationRequestNetworkOperation
extends PostNetworkOperation<RevocationServiceResponse, RevocationReceipt> {
    @NotNull
    private final Json serializer;
    @NotNull
    private final Function1<Continuation<? super Response<RevocationServiceResponse>>, Object> call;

    public SendVerifiablePresentationRevocationRequestNetworkOperation(@NotNull String url, @NotNull String serializedResponse, @NotNull ApiProvider apiProvider, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)serializedResponse, (String)"serializedResponse");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.serializer = serializer2;
        this.call = (Function1)new Function1<Continuation<? super Response<RevocationServiceResponse>>, Object>(apiProvider, url, serializedResponse, null){
            int label;
            final /* synthetic */ ApiProvider $apiProvider;
            final /* synthetic */ String $url;
            final /* synthetic */ String $serializedResponse;
            {
                this.$apiProvider = $apiProvider;
                this.$url = $url;
                this.$serializedResponse = $serializedResponse;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$apiProvider.getRevocationApis().sendResponse(this.$url, this.$serializedResponse, (Continuation<? super Response<RevocationServiceResponse>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<RevocationServiceResponse>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @Override
    @NotNull
    public Function1<Continuation<? super Response<RevocationServiceResponse>>, Object> getCall() {
        return this.call;
    }

    @Override
    @Nullable
    public Object onSuccess(@NotNull Response<RevocationServiceResponse> response, @NotNull Continuation<? super Result<RevocationReceipt>> $completion) {
        Set receipts;
        Object object = (RevocationServiceResponse)response.body();
        Set set = object != null && (object = ((RevocationServiceResponse)object).getReceipt()) != null ? ((HashMap)object).entrySet() : (receipts = null);
        if (receipts == null || receipts.isEmpty()) {
            throw new RevocationException("No Receipt in revocation response body", null, false, 6, null);
        }
        Object v = ((Map.Entry)CollectionsKt.first((Iterable)receipts)).getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"receipts.first().value");
        String serializedReceipt = (String)v;
        RevocationReceipt revocationReceipt = this.unwrapRevocationReceipt(serializedReceipt, this.serializer);
        return new Result.Success<RevocationReceipt>(revocationReceipt);
    }

    @NotNull
    public final RevocationReceipt unwrapRevocationReceipt(@NotNull String signedReceipt, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)signedReceipt, (String)"signedReceipt");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        JwsToken token = JwsToken.Companion.deserialize(signedReceipt);
        return (RevocationReceipt)serializer2.decodeFromString((DeserializationStrategy)RevocationReceipt.Companion.serializer(), token.content());
    }
}

