/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.network.credentialOperations;

import com.microsoft.did.sdk.credential.service.models.contracts.VerifiableCredentialContract;
import com.microsoft.did.sdk.credential.service.models.serviceResponses.ContractServiceResponse;
import com.microsoft.did.sdk.credential.service.validators.JwtValidator;
import com.microsoft.did.sdk.crypto.protocols.jose.jws.JwsToken;
import com.microsoft.did.sdk.datasource.network.GetNetworkOperation;
import com.microsoft.did.sdk.datasource.network.apis.ApiProvider;
import com.microsoft.did.sdk.datasource.network.credentialOperations.FetchContractNetworkOperation;
import com.microsoft.did.sdk.util.controlflow.DidInHeaderAndPayloadNotMatching;
import com.microsoft.did.sdk.util.controlflow.InvalidSignatureException;
import com.microsoft.did.sdk.util.controlflow.IssuanceException;
import com.microsoft.did.sdk.util.controlflow.Result;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u001c\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR5\u0010\r\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000eX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lcom/microsoft/did/sdk/datasource/network/credentialOperations/FetchContractNetworkOperation;", "Lcom/microsoft/did/sdk/datasource/network/GetNetworkOperation;", "Lcom/microsoft/did/sdk/credential/service/models/serviceResponses/ContractServiceResponse;", "Lcom/microsoft/did/sdk/credential/service/models/contracts/VerifiableCredentialContract;", "url", "", "apiProvider", "Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;", "jwtValidator", "Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;", "serializer", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/String;Lcom/microsoft/did/sdk/datasource/network/apis/ApiProvider;Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;Lkotlinx/serialization/json/Json;)V", "call", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lretrofit2/Response;", "", "getCall", "()Lkotlin/jvm/functions/Function1;", "Lkotlin/jvm/functions/Function1;", "getUrl", "()Ljava/lang/String;", "onSuccess", "Lcom/microsoft/did/sdk/util/controlflow/Result;", "response", "(Lretrofit2/Response;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyAndUnwrapContract", "jwsTokenString", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "walletlibrary_release"})
public final class FetchContractNetworkOperation
extends GetNetworkOperation<ContractServiceResponse, VerifiableCredentialContract> {
    @NotNull
    private final String url;
    @NotNull
    private final JwtValidator jwtValidator;
    @NotNull
    private final Json serializer;
    @NotNull
    private final Function1<Continuation<? super Response<ContractServiceResponse>>, Object> call;

    public FetchContractNetworkOperation(@NotNull String url, @NotNull ApiProvider apiProvider, @NotNull JwtValidator jwtValidator, @NotNull Json serializer2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter((Object)jwtValidator, (String)"jwtValidator");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.url = url;
        this.jwtValidator = jwtValidator;
        this.serializer = serializer2;
        this.call = (Function1)new Function1<Continuation<? super Response<ContractServiceResponse>>, Object>(apiProvider, this, null){
            int label;
            final /* synthetic */ ApiProvider $apiProvider;
            final /* synthetic */ FetchContractNetworkOperation this$0;
            {
                this.$apiProvider = $apiProvider;
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$apiProvider.getIssuanceApis().getContract(this.this$0.getUrl(), (Continuation<? super Response<ContractServiceResponse>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<ContractServiceResponse>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public Function1<Continuation<? super Response<ContractServiceResponse>>, Object> getCall() {
        return this.call;
    }

    @Override
    @Nullable
    public Object onSuccess(@NotNull Response<ContractServiceResponse> response, @NotNull Continuation<? super Result<VerifiableCredentialContract>> $completion) {
        Object object = (ContractServiceResponse)response.body();
        if (object == null || (object = ((ContractServiceResponse)object).getToken()) == null) {
            throw new IssuanceException("Contract was not found in response", null, false, 6, null);
        }
        Object jwsTokenString = object;
        return this.verifyAndUnwrapContract((String)jwsTokenString, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object verifyAndUnwrapContract(String var1_1, Continuation<? super Result<VerifiableCredentialContract>> var2_2) {
        if (!(var2_2 instanceof verifyAndUnwrapContract.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FetchContractNetworkOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FetchContractNetworkOperation.access$verifyAndUnwrapContract(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                jwsToken = JwsToken.Companion.deserialize((String)jwsTokenString);
                verifiableCredentialContract = (VerifiableCredentialContract)this.serializer.decodeFromString((DeserializationStrategy)VerifiableCredentialContract.Companion.serializer(), jwsToken.content());
                $continuation.L$0 = this;
                $continuation.L$1 = jwsToken;
                $continuation.L$2 = verifiableCredentialContract;
                $continuation.label = 1;
                v0 = this.jwtValidator.verifySignature(jwsToken, (Continuation<? super Boolean>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                verifiableCredentialContract = (VerifiableCredentialContract)$continuation.L$2;
                jwsToken = (JwsToken)$continuation.L$1;
                this = (FetchContractNetworkOperation)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    throw new InvalidSignatureException("Signature is not valid on Issuance Request.");
                }
                if (!this.jwtValidator.validateDidInHeaderAndPayload(jwsToken, verifiableCredentialContract.getInput().getIssuer())) {
                    throw new DidInHeaderAndPayloadNotMatching("DID used to sign the contract doesn't match the DID in the contract.");
                }
                return new Result.Success<VerifiableCredentialContract>(verifiableCredentialContract);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$verifyAndUnwrapContract(FetchContractNetworkOperation $this, String jwsTokenString, Continuation $completion) {
        return $this.verifyAndUnwrapContract(jwsTokenString, (Continuation<? super Result<VerifiableCredentialContract>>)$completion);
    }
}

