/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.datasource.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.microsoft.did.sdk.datasource.db.dao.IdentifierDao;
import com.microsoft.did.sdk.identifier.models.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class IdentifierDao_Impl
implements IdentifierDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Identifier> __insertionAdapterOfIdentifier;
    private final SharedSQLiteStatement __preparedStmtOfDeleteIdentifier;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public IdentifierDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfIdentifier = new EntityInsertionAdapter<Identifier>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Identifier` (`id`,`signatureKeyReference`,`encryptionKeyReference`,`recoveryKeyReference`,`updateKeyReference`,`name`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Identifier value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getSignatureKeyReference() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSignatureKeyReference());
                }
                if (value.getEncryptionKeyReference() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEncryptionKeyReference());
                }
                if (value.getRecoveryKeyReference() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRecoveryKeyReference());
                }
                if (value.getUpdateKeyReference() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUpdateKeyReference());
                }
                if (value.getName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getName());
                }
            }
        };
        this.__preparedStmtOfDeleteIdentifier = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Identifier where id = ?";
                return "DELETE FROM Identifier where id = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Identifier";
                return "DELETE FROM Identifier";
            }
        };
    }

    @Override
    public Object insert(final Identifier identifier, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                IdentifierDao_Impl.this.__db.beginTransaction();
                try {
                    IdentifierDao_Impl.this.__insertionAdapterOfIdentifier.insert((Object)identifier);
                    IdentifierDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    IdentifierDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteIdentifier(final String identifier, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = IdentifierDao_Impl.this.__preparedStmtOfDeleteIdentifier.acquire();
                int _argIndex = 1;
                if (identifier == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, identifier);
                }
                IdentifierDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    IdentifierDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    IdentifierDao_Impl.this.__db.endTransaction();
                    IdentifierDao_Impl.this.__preparedStmtOfDeleteIdentifier.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteAll(Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = IdentifierDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                IdentifierDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    IdentifierDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    IdentifierDao_Impl.this.__db.endTransaction();
                    IdentifierDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object queryByIdentifier(String identifier, Continuation<? super Identifier> continuation) {
        String _sql = "SELECT * FROM Identifier where id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Identifier where id = ?", (int)1);
        int _argIndex = 1;
        if (identifier == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, identifier);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Identifier call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)IdentifierDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Identifier _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSignatureKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signatureKeyReference");
                    int _cursorIndexOfEncryptionKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encryptionKeyReference");
                    int _cursorIndexOfRecoveryKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recoveryKeyReference");
                    int _cursorIndexOfUpdateKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateKeyReference");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSignatureKeyReference = _cursor.isNull(_cursorIndexOfSignatureKeyReference) ? null : _cursor.getString(_cursorIndexOfSignatureKeyReference);
                        String _tmpEncryptionKeyReference = _cursor.isNull(_cursorIndexOfEncryptionKeyReference) ? null : _cursor.getString(_cursorIndexOfEncryptionKeyReference);
                        String _tmpRecoveryKeyReference = _cursor.isNull(_cursorIndexOfRecoveryKeyReference) ? null : _cursor.getString(_cursorIndexOfRecoveryKeyReference);
                        String _tmpUpdateKeyReference = _cursor.isNull(_cursorIndexOfUpdateKeyReference) ? null : _cursor.getString(_cursorIndexOfUpdateKeyReference);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result = new Identifier(_tmpId, _tmpSignatureKeyReference, _tmpEncryptionKeyReference, _tmpRecoveryKeyReference, _tmpUpdateKeyReference, _tmpName);
                    } else {
                        _result = null;
                    }
                    Identifier identifier = _result;
                    return identifier;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object queryByName(String name, Continuation<? super Identifier> continuation) {
        String _sql = "SELECT * FROM Identifier where name= ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Identifier where name= ?", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Identifier>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Identifier call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)IdentifierDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Identifier _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSignatureKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signatureKeyReference");
                    int _cursorIndexOfEncryptionKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encryptionKeyReference");
                    int _cursorIndexOfRecoveryKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recoveryKeyReference");
                    int _cursorIndexOfUpdateKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateKeyReference");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSignatureKeyReference = _cursor.isNull(_cursorIndexOfSignatureKeyReference) ? null : _cursor.getString(_cursorIndexOfSignatureKeyReference);
                        String _tmpEncryptionKeyReference = _cursor.isNull(_cursorIndexOfEncryptionKeyReference) ? null : _cursor.getString(_cursorIndexOfEncryptionKeyReference);
                        String _tmpRecoveryKeyReference = _cursor.isNull(_cursorIndexOfRecoveryKeyReference) ? null : _cursor.getString(_cursorIndexOfRecoveryKeyReference);
                        String _tmpUpdateKeyReference = _cursor.isNull(_cursorIndexOfUpdateKeyReference) ? null : _cursor.getString(_cursorIndexOfUpdateKeyReference);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result = new Identifier(_tmpId, _tmpSignatureKeyReference, _tmpEncryptionKeyReference, _tmpRecoveryKeyReference, _tmpUpdateKeyReference, _tmpName);
                    } else {
                        _result = null;
                    }
                    Identifier identifier = _result;
                    return identifier;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object queryAllLocal(Continuation<? super List<Identifier>> continuation) {
        String _sql = "SELECT * FROM Identifier";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Identifier", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Identifier>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Identifier> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)IdentifierDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSignatureKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signatureKeyReference");
                    int _cursorIndexOfEncryptionKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encryptionKeyReference");
                    int _cursorIndexOfRecoveryKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recoveryKeyReference");
                    int _cursorIndexOfUpdateKeyReference = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateKeyReference");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    ArrayList<Identifier> _result = new ArrayList<Identifier>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSignatureKeyReference = _cursor.isNull(_cursorIndexOfSignatureKeyReference) ? null : _cursor.getString(_cursorIndexOfSignatureKeyReference);
                        String _tmpEncryptionKeyReference = _cursor.isNull(_cursorIndexOfEncryptionKeyReference) ? null : _cursor.getString(_cursorIndexOfEncryptionKeyReference);
                        String _tmpRecoveryKeyReference = _cursor.isNull(_cursorIndexOfRecoveryKeyReference) ? null : _cursor.getString(_cursorIndexOfRecoveryKeyReference);
                        String _tmpUpdateKeyReference = _cursor.isNull(_cursorIndexOfUpdateKeyReference) ? null : _cursor.getString(_cursorIndexOfUpdateKeyReference);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        Identifier _item = new Identifier(_tmpId, _tmpSignatureKeyReference, _tmpEncryptionKeyReference, _tmpRecoveryKeyReference, _tmpUpdateKeyReference, _tmpName);
                        _result.add(_item);
                    }
                    ArrayList<Identifier> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

