/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto.keyStore;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"toPrivateJwk", "Lcom/nimbusds/jose/jwk/JWK;", "Ljava/security/KeyPair;", "keyId", "", "keyUse", "Lcom/nimbusds/jose/jwk/KeyUse;", "toPublicJwk", "walletlibrary_release"})
public final class ECKeyConverterKt {
    @NotNull
    public static final JWK toPrivateJwk(@NotNull KeyPair $this$toPrivateJwk, @NotNull String keyId, @NotNull KeyUse keyUse) {
        Intrinsics.checkNotNullParameter((Object)$this$toPrivateJwk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)keyUse, (String)"keyUse");
        PublicKey publicKey = $this$toPrivateJwk.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECKey eCKey = new ECKey.Builder(Curve.SECP256K1, (ECPublicKey)publicKey).privateKey($this$toPrivateJwk.getPrivate()).keyID(keyId).keyUse(keyUse).build();
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"Builder(Curve.SECP256K1,\u2026d).keyUse(keyUse).build()");
        return (JWK)eCKey;
    }

    @NotNull
    public static final JWK toPublicJwk(@NotNull KeyPair $this$toPublicJwk, @NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)$this$toPublicJwk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        PublicKey publicKey = $this$toPublicJwk.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECKey eCKey = new ECKey.Builder(Curve.SECP256K1, (ECPublicKey)publicKey).keyID(keyId).build();
        Intrinsics.checkNotNullExpressionValue((Object)eCKey, (String)"Builder(Curve.SECP256K1,\u2026Key).keyID(keyId).build()");
        return (JWK)eCKey;
    }
}

