/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.crypto;

import com.nimbusds.jose.jwk.Curve;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0001\rB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/did/sdk/crypto/KeyGenAlgorithm;", "", "name", "", "provider", "spec", "Ljava/security/spec/AlgorithmParameterSpec;", "(Ljava/lang/String;Ljava/lang/String;Ljava/security/spec/AlgorithmParameterSpec;)V", "getName", "()Ljava/lang/String;", "getProvider", "getSpec", "()Ljava/security/spec/AlgorithmParameterSpec;", "Secp256k1", "walletlibrary_release"})
public abstract class KeyGenAlgorithm {
    @NotNull
    private final String name;
    @Nullable
    private final String provider;
    @NotNull
    private final AlgorithmParameterSpec spec;

    public KeyGenAlgorithm(@NotNull String name, @Nullable String provider, @NotNull AlgorithmParameterSpec spec) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.name = name;
        this.provider = provider;
        this.spec = spec;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getProvider() {
        return this.provider;
    }

    @NotNull
    public final AlgorithmParameterSpec getSpec() {
        return this.spec;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/did/sdk/crypto/KeyGenAlgorithm$Secp256k1;", "Lcom/microsoft/did/sdk/crypto/KeyGenAlgorithm;", "()V", "walletlibrary_release"})
    public static final class Secp256k1
    extends KeyGenAlgorithm {
        @NotNull
        public static final Secp256k1 INSTANCE = new Secp256k1();

        private Secp256k1() {
            ECParameterSpec eCParameterSpec = Curve.SECP256K1.toECParameterSpec();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"SECP256K1.toECParameterSpec()");
            super("EC", null, eCParameterSpec);
        }
    }
}

