/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.validators;

import com.microsoft.did.sdk.credential.service.PresentationRequest;
import com.microsoft.did.sdk.credential.service.models.oidc.PinDetails;
import com.microsoft.did.sdk.credential.service.models.oidc.Registration;
import com.microsoft.did.sdk.credential.service.validators.JwtValidator;
import com.microsoft.did.sdk.credential.service.validators.PresentationRequestValidator;
import com.microsoft.did.sdk.util.controlflow.InvalidPinDetailsException;
import com.microsoft.did.sdk.util.controlflow.InvalidResponseModeException;
import com.microsoft.did.sdk.util.controlflow.InvalidResponseTypeException;
import com.microsoft.did.sdk.util.controlflow.InvalidScopeException;
import com.microsoft.did.sdk.util.controlflow.MissingInputInRequestException;
import com.microsoft.did.sdk.util.controlflow.SubjectIdentifierTypeNotSupported;
import com.microsoft.did.sdk.util.controlflow.VpFormatNotSupported;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u0019\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/microsoft/did/sdk/credential/service/validators/OidcPresentationRequestValidator;", "Lcom/microsoft/did/sdk/credential/service/validators/PresentationRequestValidator;", "jwtValidator", "Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;", "(Lcom/microsoft/did/sdk/credential/service/validators/JwtValidator;)V", "checkForInputInPresentationRequest", "", "request", "Lcom/microsoft/did/sdk/credential/service/PresentationRequest;", "checkRegistrationParameters", "registration", "Lcom/microsoft/did/sdk/credential/service/models/oidc/Registration;", "checkResponseMode", "responseMode", "", "checkResponseType", "responseType", "checkScope", "scope", "getExpirationDeadlineInSeconds", "", "expirationCheckTimeOffsetInMinutes", "", "validate", "(Lcom/microsoft/did/sdk/credential/service/PresentationRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validatePinDetails", "pinDetails", "Lcom/microsoft/did/sdk/credential/service/models/oidc/PinDetails;", "walletlibrary_release"})
public final class OidcPresentationRequestValidator
implements PresentationRequestValidator {
    @NotNull
    private final JwtValidator jwtValidator;

    @Inject
    public OidcPresentationRequestValidator(@NotNull JwtValidator jwtValidator) {
        Intrinsics.checkNotNullParameter((Object)jwtValidator, (String)"jwtValidator");
        this.jwtValidator = jwtValidator;
    }

    @Override
    @Nullable
    public Object validate(@NotNull PresentationRequest request, @NotNull Continuation<? super Unit> $completion) {
        this.checkResponseMode(request.getContent().getResponseMode());
        this.checkResponseType(request.getContent().getResponseType());
        this.checkScope(request.getContent().getScope());
        this.checkForInputInPresentationRequest(request);
        this.checkRegistrationParameters(request.getContent().getRegistration());
        this.validatePinDetails(request.getContent().getPinDetails());
        return Unit.INSTANCE;
    }

    private final void checkRegistrationParameters(Registration registration) {
        if (!registration.getSubjectSyntaxTypesSupported().contains("did:ion")) {
            throw new SubjectIdentifierTypeNotSupported("The subject identifier type in registration of request is not supported");
        }
        if (registration.getVpFormats() != null && !registration.getVpFormats().getJwtVp().contains("ES256K")) {
            throw new VpFormatNotSupported("VP format algorithm in registration of request is not supported");
        }
        if (registration.getVpFormats() != null && !registration.getVpFormats().getJwtVc().contains("ES256K")) {
            throw new VpFormatNotSupported("VC format algorithm in registration of request is not supported");
        }
    }

    private final void checkResponseType(String responseType) {
        if (!StringsKt.equals((String)responseType, (String)"id_token", (boolean)true)) {
            throw new InvalidResponseTypeException("Invalid response type in presentation request.");
        }
    }

    private final void checkResponseMode(String responseMode) {
        if (!StringsKt.equals((String)responseMode, (String)"post", (boolean)true)) {
            throw new InvalidResponseModeException("Invalid response mode in presentation request.");
        }
    }

    private final void checkScope(String scope) {
        if (!StringsKt.equals((String)scope, (String)"openid", (boolean)true)) {
            throw new InvalidScopeException("Invalid scope in presentation request.");
        }
    }

    private final long getExpirationDeadlineInSeconds(int expirationCheckTimeOffsetInMinutes) {
        long currentTimeInSeconds = new Date().getTime() / (long)1000;
        return currentTimeInSeconds - (long)(60 * expirationCheckTimeOffsetInMinutes);
    }

    static /* synthetic */ long getExpirationDeadlineInSeconds$default(OidcPresentationRequestValidator oidcPresentationRequestValidator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        return oidcPresentationRequestValidator.getExpirationDeadlineInSeconds(n);
    }

    private final void checkForInputInPresentationRequest(PresentationRequest request) {
        Collection collection = request.getPresentationDefinition().getCredentialPresentationInputDescriptors();
        if (collection == null || collection.isEmpty()) {
            throw new MissingInputInRequestException("Input Descriptor is missing in presentation request.");
        }
    }

    private final void validatePinDetails(PinDetails pinDetails) {
        if (pinDetails == null) {
            return;
        }
        int length = pinDetails.getLength();
        String type = pinDetails.getType();
        if (length < 1) {
            throw new InvalidPinDetailsException("PIN length is invalid in request.");
        }
        if (!Intrinsics.areEqual((Object)type, (Object)"numeric") && !Intrinsics.areEqual((Object)type, (Object)"alphanumeric")) {
            throw new InvalidPinDetailsException("PIN type is invalid in request.");
        }
    }
}

