/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.credential.service.protectors;

import com.microsoft.did.sdk.credential.models.VerifiableCredential;
import com.microsoft.did.sdk.credential.service.PresentationResponse;
import com.microsoft.did.sdk.credential.service.models.oidc.PresentationResponseClaims;
import com.microsoft.did.sdk.credential.service.models.oidc.VpTokenInResponse;
import com.microsoft.did.sdk.credential.service.models.presentationexchange.CredentialPresentationInputDescriptor;
import com.microsoft.did.sdk.credential.service.models.presentationexchange.PresentationSubmission;
import com.microsoft.did.sdk.credential.service.models.presentationexchange.PresentationSubmissionDescriptor;
import com.microsoft.did.sdk.credential.service.protectors.FormatterHelpersKt;
import com.microsoft.did.sdk.credential.service.protectors.TokenSigner;
import com.microsoft.did.sdk.credential.service.protectors.VerifiablePresentationFormatter;
import com.microsoft.did.sdk.identifier.models.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J8\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002JF\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00192\u0018\b\u0002\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/did/sdk/credential/service/protectors/PresentationResponseFormatter;", "", "serializer", "Lkotlinx/serialization/json/Json;", "verifiablePresentationFormatter", "Lcom/microsoft/did/sdk/credential/service/protectors/VerifiablePresentationFormatter;", "signer", "Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;", "(Lkotlinx/serialization/json/Json;Lcom/microsoft/did/sdk/credential/service/protectors/VerifiablePresentationFormatter;Lcom/microsoft/did/sdk/credential/service/protectors/TokenSigner;)V", "createAttestationsAndPresentationSubmission", "Lcom/microsoft/did/sdk/credential/service/models/presentationexchange/PresentationSubmission;", "presentationResponse", "Lcom/microsoft/did/sdk/credential/service/PresentationResponse;", "createPresentations", "", "requestedVcPresentationSubmissionMap", "", "Lcom/microsoft/did/sdk/credential/service/models/presentationexchange/CredentialPresentationInputDescriptor;", "Lcom/microsoft/did/sdk/credential/models/VerifiableCredential;", "Lcom/microsoft/did/sdk/credential/service/RequestedVcPresentationSubmissionMap;", "audience", "responder", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "nonce", "formatResponse", "Lkotlin/Pair;", "expiryInSeconds", "", "signContents", "contents", "Lcom/microsoft/did/sdk/credential/service/models/oidc/PresentationResponseClaims;", "walletlibrary_release"})
public final class PresentationResponseFormatter {
    @NotNull
    private final Json serializer;
    @NotNull
    private final VerifiablePresentationFormatter verifiablePresentationFormatter;
    @NotNull
    private final TokenSigner signer;

    @Inject
    public PresentationResponseFormatter(@NotNull Json serializer2, @NotNull VerifiablePresentationFormatter verifiablePresentationFormatter, @NotNull TokenSigner signer) {
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)verifiablePresentationFormatter, (String)"verifiablePresentationFormatter");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.serializer = serializer2;
        this.verifiablePresentationFormatter = verifiablePresentationFormatter;
        this.signer = signer;
    }

    @NotNull
    public final Pair<String, String> formatResponse(@NotNull Map<CredentialPresentationInputDescriptor, VerifiableCredential> requestedVcPresentationSubmissionMap, @NotNull PresentationResponse presentationResponse, @NotNull Identifier responder, int expiryInSeconds) {
        PresentationResponseClaims presentationResponseClaims;
        Intrinsics.checkNotNullParameter(requestedVcPresentationSubmissionMap, (String)"requestedVcPresentationSubmissionMap");
        Intrinsics.checkNotNullParameter((Object)presentationResponse, (String)"presentationResponse");
        Intrinsics.checkNotNullParameter((Object)responder, (String)"responder");
        Pair<Long, Long> pair = FormatterHelpersKt.createIssuedAndExpiryTime(expiryInSeconds);
        long issuedTime = ((Number)pair.component1()).longValue();
        long expiryTime = ((Number)pair.component2()).longValue();
        PresentationSubmission credentialPresentationSubmission = this.createAttestationsAndPresentationSubmission(presentationResponse);
        PresentationResponseClaims $this$formatResponse_u24lambda_u2d0 = presentationResponseClaims = new PresentationResponseClaims(new VpTokenInResponse(credentialPresentationSubmission), null, 2, null);
        boolean bl = false;
        $this$formatResponse_u24lambda_u2d0.setSubject(responder.getId());
        $this$formatResponse_u24lambda_u2d0.setAudience(presentationResponse.getAudience());
        $this$formatResponse_u24lambda_u2d0.setNonce(presentationResponse.getRequest().getContent().getNonce());
        $this$formatResponse_u24lambda_u2d0.setResponseCreationTime(issuedTime);
        $this$formatResponse_u24lambda_u2d0.setResponseExpirationTime(expiryTime);
        PresentationResponseClaims oidcResponseClaims = presentationResponseClaims;
        String attestationResponse = this.createPresentations(requestedVcPresentationSubmissionMap, presentationResponse.getRequest().getContent().getClientId(), responder, presentationResponse.getRequest().getContent().getNonce());
        String idToken = this.signContents(oidcResponseClaims, responder);
        return new Pair((Object)idToken, (Object)attestationResponse);
    }

    public static /* synthetic */ Pair formatResponse$default(PresentationResponseFormatter presentationResponseFormatter, Map map, PresentationResponse presentationResponse, Identifier identifier, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n2 & 8) != 0) {
            n = 3600;
        }
        return presentationResponseFormatter.formatResponse(map, presentationResponse, identifier, n);
    }

    /*
     * WARNING - void declaration
     */
    private final PresentationSubmission createAttestationsAndPresentationSubmission(PresentationResponse presentationResponse) {
        void $this$mapTo$iv$iv;
        CollectionsKt.getIndices((Collection)presentationResponse.getRequestedVcPresentationSubmissionMap().entrySet());
        Map<CredentialPresentationInputDescriptor, VerifiableCredential> $this$map$iv = presentationResponse.getRequestedVcPresentationSubmissionMap();
        boolean $i$f$map = false;
        Map<CredentialPresentationInputDescriptor, VerifiableCredential> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void pair;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PresentationSubmissionDescriptor(((CredentialPresentationInputDescriptor)pair.getKey()).getId(), "jwt_vp", "$", new PresentationSubmissionDescriptor(((CredentialPresentationInputDescriptor)pair.getKey()).getId(), "jwt_vc", "$.verifiableCredential[" + MapsKt.toList(presentationResponse.getRequestedVcPresentationSubmissionMap()).indexOf(new Pair(pair.getKey(), pair.getValue())) + ']', null, 8, null)));
        }
        List credentialPresentationSubmissionDescriptors = (List)destination$iv$iv;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String presentationSubmissionId = string;
        return new PresentationSubmission(presentationSubmissionId, presentationResponse.getRequestedVcPresentationDefinitionId(), credentialPresentationSubmissionDescriptors);
    }

    private final String createPresentations(Map<CredentialPresentationInputDescriptor, VerifiableCredential> requestedVcPresentationSubmissionMap, String audience, Identifier responder, String nonce) {
        return this.verifiablePresentationFormatter.createPresentation(CollectionsKt.toList((Iterable)requestedVcPresentationSubmissionMap.values()), 3600, audience, responder, nonce);
    }

    private final String signContents(PresentationResponseClaims contents, Identifier responder) {
        String serializedResponseContent = this.serializer.encodeToString((SerializationStrategy)PresentationResponseClaims.Companion.serializer(), (Object)contents);
        return this.signer.signWithIdentifier(serializedResponseContent, responder);
    }
}

