/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk.backup.content.microsoft2020;

import com.microsoft.did.sdk.backup.content.microsoft2020.RawIdentifierConverter;
import com.microsoft.did.sdk.backup.content.microsoft2020.RawIdentity;
import com.microsoft.did.sdk.crypto.keyStore.EncryptedKeyStore;
import com.microsoft.did.sdk.datasource.repository.IdentifierRepository;
import com.microsoft.did.sdk.identifier.models.Identifier;
import com.microsoft.did.sdk.util.controlflow.KeyException;
import com.microsoft.did.sdk.util.controlflow.MalformedIdentityException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyUse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J2\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00140\u001e2\u0006\u0010\u001f\u001a\u00020\bJ&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/microsoft/did/sdk/backup/content/microsoft2020/RawIdentifierConverter;", "", "identityRepository", "Lcom/microsoft/did/sdk/datasource/repository/IdentifierRepository;", "keyStore", "Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;", "(Lcom/microsoft/did/sdk/datasource/repository/IdentifierRepository;Lcom/microsoft/did/sdk/crypto/keyStore/EncryptedKeyStore;)V", "createRawIdentifier", "Lcom/microsoft/did/sdk/backup/content/microsoft2020/RawIdentity;", "identity", "Lcom/microsoft/did/sdk/identifier/models/Identifier;", "getAllIdentifiers", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIdentifierKeys", "Lcom/nimbusds/jose/jwk/JWK;", "getKeyFromKeySet", "keyUse", "Lcom/nimbusds/jose/jwk/KeyUse;", "keySet", "", "exclude", "", "getKidFromJWK", "jwk", "keyIsEncrypting", "", "key", "keyIsSigning", "parseRawIdentifier", "Lkotlin/Pair;", "identifierData", "rawIdentifierToKeySet", "updateKeyRef", "recoveryKeyRef", "walletlibrary_release"})
public final class RawIdentifierConverter {
    @NotNull
    private final IdentifierRepository identityRepository;
    @NotNull
    private final EncryptedKeyStore keyStore;

    @Inject
    public RawIdentifierConverter(@NotNull IdentifierRepository identityRepository, @NotNull EncryptedKeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)identityRepository, (String)"identityRepository");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this.identityRepository = identityRepository;
        this.keyStore = keyStore;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getAllIdentifiers(@NotNull Continuation<? super List<RawIdentity>> var1_1) {
        if (!(var1_1 instanceof getAllIdentifiers.1)) ** GOTO lbl-1000
        var13_2 = var1_1;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RawIdentifierConverter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getAllIdentifiers((Continuation<? super List<RawIdentity>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.identityRepository.queryAllLocal((Continuation<? super List<Identifier>>)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (RawIdentifierConverter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $this$map$iv = (Iterable)v0;
                $i$f$map = false;
                var4_7 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var9_12 = (Identifier)item$iv$iv;
                    var11_14 = destination$iv$iv;
                    $i$a$-map-RawIdentifierConverter$getAllIdentifiers$2 = false;
                    var11_14.add(this.createRawIdentifier((Identifier)did));
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final Pair<Identifier, Set<JWK>> parseRawIdentifier(@NotNull RawIdentity identifierData) {
        Intrinsics.checkNotNullParameter((Object)identifierData, (String)"identifierData");
        String updateKeyRef = identifierData.getUpdateKey();
        String recoveryKeyRef = identifierData.getRecoveryKey();
        Set<JWK> keySet = this.rawIdentifierToKeySet(identifierData, updateKeyRef, recoveryKeyRef);
        if (StringsKt.isBlank((CharSequence)updateKeyRef) || StringsKt.isBlank((CharSequence)recoveryKeyRef)) {
            throw new MalformedIdentityException("update and recovery key required", null, 2, null);
        }
        Object[] objectArray = new String[]{updateKeyRef, recoveryKeyRef};
        List excludeKeysForUse = CollectionsKt.listOf((Object[])objectArray);
        String string = identifierData.getId();
        KeyUse keyUse = KeyUse.SIGNATURE;
        Intrinsics.checkNotNullExpressionValue((Object)keyUse, (String)"SIGNATURE");
        JWK jWK = this.getKeyFromKeySet(keyUse, keySet, excludeKeysForUse);
        String string2 = jWK != null ? jWK.getKeyID() : null;
        if (string2 == null) {
            string2 = "";
        }
        KeyUse keyUse2 = KeyUse.ENCRYPTION;
        Intrinsics.checkNotNullExpressionValue((Object)keyUse2, (String)"ENCRYPTION");
        JWK jWK2 = this.getKeyFromKeySet(keyUse2, keySet, excludeKeysForUse);
        String string3 = jWK2 != null ? jWK2.getKeyID() : null;
        if (string3 == null) {
            string3 = "";
        }
        Identifier id = new Identifier(string, string2, string3, recoveryKeyRef, updateKeyRef, identifierData.getName());
        return new Pair((Object)id, keySet);
    }

    /*
     * Unable to fully structure code
     */
    private final JWK getKeyFromKeySet(KeyUse keyUse, Set<? extends JWK> keySet, List<String> exclude) {
        block9: {
            block10: {
                block7: {
                    block8: {
                        block6: {
                            var4_4 = keyUse;
                            if (!Intrinsics.areEqual((Object)var4_4, (Object)KeyUse.SIGNATURE)) break block8;
                            $this$firstOrNull$iv = keySet;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (JWK)element$iv;
                                $i$a$-firstOrNull-RawIdentifierConverter$getKeyFromKeySet$1 = false;
                                if (!this.keyIsSigning(it)) ** GOTO lbl-1000
                                v0 = exclude;
                                if (!(v0 != null ? v0.contains(it.getKeyID()) : false)) {
                                    v1 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v1 = false;
                                }
                                if (!v1) continue;
                                v2 = element$iv;
                                break block6;
                            }
                            v2 = null;
                        }
                        v3 = v2;
                        break block9;
                    }
                    if (!Intrinsics.areEqual((Object)var4_4, (Object)KeyUse.ENCRYPTION)) break block10;
                    $this$firstOrNull$iv = keySet;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (JWK)element$iv;
                        $i$a$-firstOrNull-RawIdentifierConverter$getKeyFromKeySet$2 = false;
                        if (!this.keyIsEncrypting(it)) ** GOTO lbl-1000
                        v4 = exclude;
                        if (!(v4 != null ? v4.contains(it.getKeyID()) : false)) {
                            v5 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (!v5) continue;
                        v6 = element$iv;
                        break block7;
                    }
                    v6 = null;
                }
                v3 = v6;
                break block9;
            }
            v3 = null;
        }
        return v3;
    }

    static /* synthetic */ JWK getKeyFromKeySet$default(RawIdentifierConverter rawIdentifierConverter, KeyUse keyUse, Set set, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return rawIdentifierConverter.getKeyFromKeySet(keyUse, set, list);
    }

    private final Set<JWK> rawIdentifierToKeySet(RawIdentity identifierData, String updateKeyRef, String recoveryKeyRef) {
        String signingKeyRef = "";
        String encryptingKeyRef = "";
        Set keySet = new LinkedHashSet();
        for (JWK key : identifierData.getKeys()) {
            if (StringsKt.isBlank((CharSequence)signingKeyRef) && this.keyIsSigning(key)) {
                signingKeyRef = this.getKidFromJWK(key);
                keySet.add(key);
                continue;
            }
            if (StringsKt.isBlank((CharSequence)encryptingKeyRef) && this.keyIsEncrypting(key)) {
                encryptingKeyRef = this.getKidFromJWK(key);
                keySet.add(key);
                continue;
            }
            if (Intrinsics.areEqual((Object)key.getKeyID(), (Object)updateKeyRef)) {
                this.getKidFromJWK(key);
                keySet.add(key);
                continue;
            }
            if (!Intrinsics.areEqual((Object)key.getKeyID(), (Object)recoveryKeyRef)) continue;
            this.getKidFromJWK(key);
            keySet.add(key);
        }
        return keySet;
    }

    private final boolean keyIsSigning(JWK key) {
        boolean bl;
        Set set = key.getKeyOperations();
        if (set != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KeyOperation it = (KeyOperation)element$iv;
                        boolean bl3 = false;
                        Object[] objectArray = new KeyOperation[]{KeyOperation.SIGN, KeyOperation.VERIFY};
                        if (!CollectionsKt.listOf((Object[])objectArray).contains(it)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl || Intrinsics.areEqual((Object)key.getKeyUse(), (Object)KeyUse.SIGNATURE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean keyIsEncrypting(JWK key) {
        boolean bl;
        boolean bl2;
        Object[] objectArray;
        KeyOperation it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Set set = key.getKeyOperations();
        if (set != null) {
            boolean bl3;
            $this$any$iv = set;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KeyOperation)element$iv;
                    boolean bl4 = false;
                    objectArray = new KeyOperation[]{KeyOperation.ENCRYPT, KeyOperation.DECRYPT};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(it)) continue;
                    return true;
                }
                bl3 = false;
            }
            if (bl3) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Set set2 = key.getKeyOperations();
        if (set2 != null) {
            boolean bl5;
            $this$any$iv = set2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl5 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KeyOperation)element$iv;
                    boolean bl6 = false;
                    objectArray = new KeyOperation[]{KeyOperation.WRAP_KEY, KeyOperation.UNWRAP_KEY};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(it)) continue;
                    return true;
                }
                bl5 = false;
            }
            if (bl5) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!Intrinsics.areEqual((Object)key.getKeyUse(), (Object)KeyUse.ENCRYPTION)) return false;
        return true;
    }

    private final String getKidFromJWK(JWK jwk) {
        String string = jwk.getKeyID();
        if (string == null) {
            throw new KeyException("Imported JWK has no key id.", null, 2, null);
        }
        return string;
    }

    private final RawIdentity createRawIdentifier(Identifier identity) {
        String string = identity.getId();
        String string2 = identity.getName();
        List<JWK> list = this.getIdentifierKeys(identity);
        String string3 = identity.getUpdateKeyReference();
        String string4 = identity.getRecoveryKeyReference();
        return new RawIdentity(string, string2, list, string4, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JWK> getIdentifierKeys(Identifier identity) {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new String[]{identity.getEncryptionKeyReference(), identity.getSignatureKeyReference(), identity.getUpdateKeyReference(), identity.getRecoveryKeyReference()};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JWK it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String keyId = (String)element$iv$iv;
            boolean bl2 = false;
            if ((!StringsKt.isBlank((CharSequence)keyId) ? this.keyStore.getKey(keyId) : (JWK)null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

