/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.did.sdk;

import android.content.SharedPreferences;
import com.microsoft.correlationvector.CorrelationVector;
import com.microsoft.correlationvector.CorrelationVectorVersion;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/did/sdk/CorrelationVectorService;", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "getCorrelationVector", "", "sharedPreference", "incrementAndSave", "saveCorrelationVector", "", "correlationId", "startNewFlowAndSave", "walletlibrary_release"})
public final class CorrelationVectorService {
    @NotNull
    private final SharedPreferences sharedPreferences;

    @Inject
    public CorrelationVectorService(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @NotNull
    public final String startNewFlowAndSave() {
        String correlationId = new CorrelationVector(CorrelationVectorVersion.V2).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)correlationId, (String)"correlationId");
        this.saveCorrelationVector(this.sharedPreferences, correlationId);
        return correlationId;
    }

    @NotNull
    public final String incrementAndSave() {
        String correlationVectorString = this.getCorrelationVector(this.sharedPreferences);
        if (correlationVectorString != null && ((CharSequence)correlationVectorString).length() > 0) {
            String correlationVectorIncremented = CorrelationVector.parse((String)correlationVectorString).increment();
            Intrinsics.checkNotNullExpressionValue((Object)correlationVectorIncremented, (String)"correlationVectorIncremented");
            this.saveCorrelationVector(this.sharedPreferences, correlationVectorIncremented);
            return correlationVectorIncremented;
        }
        return "";
    }

    @Nullable
    public final String getCorrelationVector(@NotNull SharedPreferences sharedPreference) {
        Intrinsics.checkNotNullParameter((Object)sharedPreference, (String)"sharedPreference");
        return sharedPreference.getString("correlation_vector", null);
    }

    public static /* synthetic */ String getCorrelationVector$default(CorrelationVectorService correlationVectorService, SharedPreferences sharedPreferences, int n, Object object) {
        if ((n & 1) != 0) {
            sharedPreferences = correlationVectorService.sharedPreferences;
        }
        return correlationVectorService.getCorrelationVector(sharedPreferences);
    }

    private final void saveCorrelationVector(SharedPreferences sharedPreferences, String correlationId) {
        if (((CharSequence)correlationId).length() > 0) {
            sharedPreferences.edit().putString("correlation_vector", correlationId).apply();
        }
    }
}

