/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.edge.seleniumtools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriverService
extends DriverService {
    public static final String EDGE_DRIVER_EXE_PROPERTY = "webdriver.edge.driver";
    public static final String EDGE_DRIVER_LOG_PROPERTY = "webdriver.edge.logfile";
    public static final String EDGE_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.edge.verboseLogging";
    public static final String EDGE_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.edge.silentOutput";
    public static final String EDGE_DRIVER_WHITELISTED_IPS_PROPERTY = "webdriver.edge.whitelistedIps";

    public EdgeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static EdgeDriverService createDefaultService() {
        return (EdgeDriverService)new Builder().build();
    }

    public static class Builder
    extends DriverService.Builder<EdgeDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.edge.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.edge.silentOutput");
        private String whitelistedIps = System.getProperty("webdriver.edge.whitelistedIps");

        public int score(Capabilities capabilities) {
            Object useChromium;
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (Objects.equals(useChromium = capabilities.getCapability("ms:edgeChromium"), false)) {
                --score;
            }
            if (capabilities.getCapability("ms:edgeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder withSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder withWhitelistedIps(String whitelistedIps) {
            this.whitelistedIps = whitelistedIps;
            return this;
        }

        protected File findDefaultExecutable() {
            return EdgeDriverService.findExecutable((String)"msedgedriver", (String)EdgeDriverService.EDGE_DRIVER_EXE_PROPERTY, (String)"https://docs.microsoft.com/en-us/microsoft-edge/webdriver-chromium", (String)"https://developer.microsoft.com/en-us/microsoft-edge/tools/webdriver");
        }

        protected ImmutableList<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(EdgeDriverService.EDGE_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add((Object)String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
            }
            if (this.verbose) {
                argsBuilder.add((Object)"--verbose");
            }
            if (this.silent) {
                argsBuilder.add((Object)"--silent");
            }
            if (this.whitelistedIps != null) {
                argsBuilder.add((Object)String.format("--whitelisted-ips=%s", this.whitelistedIps));
            }
            return argsBuilder.build();
        }

        protected EdgeDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new EdgeDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

