/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import android.util.Log;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.Verbosity;

public class AndroidLogger
implements ILogger {
    private Verbosity verbosity;
    private static AndroidLogger INSTANCE;
    private static Object InstanceLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getInstance() {
        if (INSTANCE == null) {
            Object object = InstanceLock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new AndroidLogger();
                }
            }
        }
        return INSTANCE;
    }

    private AndroidLogger() {
        this.setVerbosity(Verbosity.NONE);
    }

    @Override
    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    @Override
    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    @Override
    public void info(String TAG, String message) {
        if (this.verbosity == Verbosity.INFO) {
            Log.i((String)TAG, (String)message);
        }
    }

    @Override
    public void warn(String TAG, String message) {
        if (this.verbosity == Verbosity.WARN || this.verbosity == Verbosity.INFO) {
            Log.d((String)TAG, (String)message);
        }
    }

    @Override
    public void error(String TAG, String message) {
        if (this.verbosity == Verbosity.ERROR || this.verbosity == Verbosity.WARN || this.verbosity == Verbosity.INFO) {
            Log.e((String)TAG, (String)message);
        }
    }

    static {
        InstanceLock = new Object();
    }
}

