/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.TicketHeaders;
import com.microsoft.cll.android.TicketObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TicketManager {
    private final String TAG = "AndroidCll-TicketManager";
    private final ITicketCallback callback;
    private final ILogger logger;
    private final Map<String, String> tickets;
    private boolean needDeviceTicket = true;

    public TicketManager(ITicketCallback callback, ILogger logger) {
        this.callback = callback;
        this.logger = logger;
        this.tickets = new HashMap<String, String>();
    }

    public TicketHeaders getHeaders(boolean shouldForceRefresh) {
        if (this.callback == null || this.tickets.isEmpty()) {
            return null;
        }
        TicketHeaders headers = new TicketHeaders();
        headers.authXToken = this.callback.getAuthXToken(shouldForceRefresh);
        headers.xtokens = this.tickets;
        if (this.needDeviceTicket) {
            headers.msaDeviceTicket = this.callback.getMsaDeviceTicket(shouldForceRefresh);
        }
        return headers;
    }

    public void addTickets(List<String> ids) {
        if (ids == null || this.callback == null) {
            return;
        }
        for (String ticketId : ids) {
            if (!this.tickets.containsKey(ticketId)) {
                this.logger.info("AndroidCll-TicketManager", "Getting ticket for " + ticketId);
                TicketObject ticket = this.callback.getXTicketForXuid(ticketId);
                String ticketString = ticket.ticket;
                if (ticket.hasDeviceClaims) {
                    this.needDeviceTicket = false;
                    ticketString = "rp:" + (ticketString == null ? "" : ticketString);
                }
                this.tickets.put(ticketId, ticketString);
                continue;
            }
            this.logger.info("AndroidCll-TicketManager", "We already have a ticket for this id, skipping.");
        }
    }

    public void clean() {
        this.tickets.clear();
        this.needDeviceTicket = true;
    }
}

