/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.FileStorage;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.Tuple;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractHandler {
    private final String TAG = "AndroidCll-AbstractHandler";
    protected final ILogger logger;
    protected final ClientTelemetry clientTelemetry;
    protected FileStorage fileStorage;
    protected String filePath;
    protected static final String criticalEventFileExtension = ".crit.cllevent";
    protected static final String normalEventFileExtension = ".norm.cllevent";
    protected static AtomicLong totalStorageUsed = new AtomicLong(0L);

    public AbstractHandler(ILogger logger, String filePath, ClientTelemetry clientTelemetry) {
        this.filePath = filePath;
        this.logger = logger;
        this.clientTelemetry = clientTelemetry;
        this.setFileStorageUsed();
    }

    public abstract void add(String var1, List<String> var2) throws IOException, FileStorage.FileFullException;

    public abstract List<IStorage> getFilesForDraining();

    public abstract void close();

    public abstract void dispose(IStorage var1);

    public boolean canAdd(Tuple serializedEvent) {
        return totalStorageUsed.get() + (long)((String)serializedEvent.a).length() <= (long)SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXFILESSPACE);
    }

    protected List<IStorage> getFilesByExtensionForDraining(String fileExtension) {
        ArrayList<IStorage> fullFiles = new ArrayList<IStorage>();
        for (File file : this.findExistingFiles(fileExtension)) {
            try {
                FileStorage storage = new FileStorage(this.logger, file.getAbsolutePath(), this);
                fullFiles.add(storage);
                storage.close();
            }
            catch (Exception e) {
                this.logger.info("AndroidCll-AbstractHandler", "File " + file.getName() + " is in use still");
            }
        }
        return fullFiles;
    }

    protected File[] findExistingFiles(final String fileExtension) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(fileExtension);
            }
        };
        File[] files = new File(this.filePath).listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    private void setFileStorageUsed() {
        totalStorageUsed.set(0L);
        for (File file : this.findExistingFiles(criticalEventFileExtension)) {
            totalStorageUsed.getAndAdd(file.length());
        }
        for (File file : this.findExistingFiles(normalEventFileExtension)) {
            totalStorageUsed.getAndAdd(file.length());
        }
    }

    protected boolean ensureCanAdd(Tuple<String, List<String>> tuple, EventEnums.Persistence persistence) {
        int maxAttempts = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXCRITICALCANADDATTEMPTS);
        boolean considerCritical = persistence == EventEnums.Persistence.PersistenceCritical;
        boolean dropFileResult = true;
        boolean canAddResult = this.canAdd(tuple);
        for (int attempts = 0; !canAddResult && attempts < maxAttempts && dropFileResult; ++attempts) {
            this.logger.warn("AndroidCll-AbstractHandler", "Out of storage space. Attempting to drop one oldest file.");
            dropFileResult = this.dropOldestFile(considerCritical);
            canAddResult = this.canAdd(tuple);
        }
        return canAddResult;
    }

    protected boolean dropOldestFile(boolean includingCritical) {
        File[] files = this.findExistingFiles(normalEventFileExtension);
        if (files.length <= 1 && includingCritical) {
            files = this.findExistingFiles(criticalEventFileExtension);
        }
        if (files.length <= 1) {
            this.logger.info("AndroidCll-AbstractHandler", "There are no files to delete");
            return false;
        }
        long lastModified = files[0].lastModified();
        File lastModifiedFile = files[0];
        for (File file : files) {
            if (file.lastModified() >= lastModified) continue;
            lastModified = file.lastModified();
            lastModifiedFile = file;
        }
        long fileLength = lastModifiedFile.length();
        boolean result = this.deleteFile(lastModifiedFile);
        if (result) {
            totalStorageUsed.getAndAdd(-fileLength);
        }
        return result;
    }

    private boolean deleteFile(File file) {
        boolean result = false;
        try {
            result = file.delete();
        }
        catch (Exception e) {
            this.logger.info("AndroidCll-AbstractHandler", "Exception while deleting the file: " + e.toString());
        }
        return result;
    }
}

