/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.EventListener;
import com.microsoft.connecteddevices.SDKLoader;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class WrappedEventListener<TEventSource, TEventArg>
extends SDKLoader
implements EventListener<TEventSource, TEventArg>,
AutoCloseable {
    private long mNativeFunction;

    WrappedEventListener(long nativeFunction) {
        this.mNativeFunction = nativeFunction;
    }

    @Override
    public void onEvent(TEventSource source, TEventArg arg) {
        this.onEventNative(this.mNativeFunction, source, arg);
    }

    @Override
    public void close() {
        long tempRawPointer = this.mNativeFunction;
        if (tempRawPointer != 0L) {
            this.closeNative(tempRawPointer);
            this.mNativeFunction = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private native void onEventNative(long var1, TEventSource var3, TEventArg var4);

    private native void closeNative(long var1);
}

