/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.support.annotation.Keep;
import android.support.annotation.RequiresPermission;
import com.microsoft.connecteddevices.BluetoothWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

@Keep
final class RfcommSocket
implements Closeable {
    private BluetoothSocket _socket;
    private InputStream _inStream;
    private OutputStream _outStream;

    @RequiresPermission(value="android.permission.BLUETOOTH")
    public RfcommSocket(BluetoothDevice device, String service) throws IOException {
        this._socket = device.createInsecureRfcommSocketToServiceRecord(UUID.fromString(service));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public int connect() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter.isDiscovering() && !adapter.cancelDiscovery()) {
                BluetoothWrapper.traceWarning("Unable to 'RfcommSocket.connect': Failed to cancel in-progress system Bluetooth discovery");
                return -1;
            }
            this._socket.connect();
            this._inStream = this._socket.getInputStream();
            this._outStream = this._socket.getOutputStream();
            return 0;
        }
        catch (IOException e) {
            BluetoothWrapper.traceWarning("Exception connecting RfcommSocket. message: " + e.getMessage());
            this.close();
            return -1;
        }
        catch (SecurityException e) {
            BluetoothWrapper.traceWarning("Exception checking for or cancelling system Bluetooth discovery. message: " + e.getMessage());
            return -1;
        }
    }

    @Override
    public void close() {
        if (this._outStream != null) {
            try {
                this._outStream.flush();
            }
            catch (IOException e) {
                BluetoothWrapper.traceWarning("Exception flushing RfcommSocket OutputStream. message: " + e.getMessage());
            }
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                BluetoothWrapper.traceWarning("Exception closing RfcommSocket BluetoothSocket. message: " + e.getMessage());
            }
        }
        this._inStream = null;
        this._outStream = null;
        this._socket = null;
    }

    public int sendData(byte[] data) {
        if (!this.isConnected("sendData")) {
            return -1;
        }
        if (this._outStream == null) {
            BluetoothWrapper.traceWarning("Unable to 'sendData': RfcommSocket output stream is null");
            return -1;
        }
        try {
            this._outStream.write(data);
            return data.length;
        }
        catch (IOException e) {
            BluetoothWrapper.traceWarning("Exception RfcommSocket writing data to OutputStream. message: " + e.getMessage());
            return -1;
        }
    }

    public int receiveData(byte[] buff) {
        if (!this.isConnected("receiveData")) {
            return -1;
        }
        if (this._inStream == null) {
            BluetoothWrapper.traceWarning("Unable to 'receiveData': RfcommSocket input stream is null");
            return -1;
        }
        try {
            return this._inStream.read(buff);
        }
        catch (IOException e) {
            BluetoothWrapper.traceWarning("Exception RfcommSocket reading data from InputStream. message: " + e.getMessage());
            return -1;
        }
        catch (NullPointerException e) {
            BluetoothWrapper.traceWarning("Failed to read from RfcommSocket: buffer must not be null. message: " + e.getMessage());
            return -1;
        }
    }

    private boolean isConnected(String callingMethodName) {
        if (this._socket == null) {
            BluetoothWrapper.traceWarning(String.format("Unable to '%s': socket is null", callingMethodName));
            return false;
        }
        if (!this._socket.isConnected()) {
            BluetoothWrapper.traceWarning(String.format("Called '%s' before RfcommSocket connect", callingMethodName));
            return false;
        }
        return true;
    }
}

