/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.EventListener;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeObjectEventListener<TSourceObject extends NativeBase, TArgObject extends NativeBase> {
    private final EventListener<? super TSourceObject, ? super TArgObject> mListener;
    private final NativeObject.Creator<TSourceObject> mSourceCreator;
    private final NativeObject.Creator<TArgObject> mArgCreator;

    public NativeObjectEventListener(NativeObject.Creator<TSourceObject> sourceCreator, NativeObject.Creator<TArgObject> argCreator, @NonNull EventListener<? super TSourceObject, ? super TArgObject> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mListener = listener;
        this.mSourceCreator = sourceCreator;
        this.mArgCreator = argCreator;
    }

    @Keep
    void onEvent(NativeObject nativeEventSource, NativeObject nativeEventArg) {
        TSourceObject eventSource = NativeObject.toSpecific(nativeEventSource, this.mSourceCreator);
        TArgObject eventArg = NativeObject.toSpecific(nativeEventArg, this.mArgCreator);
        this.mListener.onEvent(eventSource, eventArg);
    }
}

