/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.util.Pair;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ErrorCode;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

@Keep
class HttpClient {
    private static final int c_readBufferSize = 4096;
    private final int HTTP_BADSECURITY = -2147220729;
    private final String mConnectSpec;
    private final String mConnectMethod;
    private final int mConnectTimeout;
    HttpURLConnection mConnection;
    private List<Pair<String, String>> mRequestHeaders = new LinkedList<Pair<String, String>>();
    private byte[] mRequestBody;
    private int mErrorCode;
    private int mResponseStatus;
    private int mResponseHeaderCount;
    private String[] mResponseHeaderKeys;
    private String[] mResponseHeaderValues;
    private byte[] mResponseBody;

    static void writeStream(OutputStream stream, byte[] data) throws IOException {
        stream.write(data);
    }

    static byte[] readStream(InputStream stream) {
        byte[] toReturn = new byte[]{};
        if (stream != null) {
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while (bytesRead != -1) {
                    result.write(buffer, 0, bytesRead);
                    bytesRead = stream.read(buffer);
                }
                toReturn = result.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    public HttpClient(String spec, String method, int timeout) {
        this.mConnectSpec = spec;
        this.mConnectMethod = method;
        this.mConnectTimeout = timeout;
    }

    public void setRequestBody(byte[] body) {
        this.mRequestBody = body;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.mRequestHeaders.add((Pair<String, String>)new Pair((Object)headerName, (Object)headerValue));
    }

    public AsyncOperation executeAsync(NativeObject completionCallback) {
        AsyncOperation<Void> connectAndReadResponseOperation = AsyncOperation.runAsync(() -> {
            try {
                this.populateResponseHeaders(Collections.emptyMap());
                this.mResponseBody = new byte[0];
                this.mErrorCode = ErrorCode.SUCCESS.getValue();
                URL url = new URL(this.mConnectSpec);
                this.mConnection = (HttpURLConnection)url.openConnection();
                if (HttpsURLConnection.class.isInstance(this.mConnection)) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.mConnection;
                    SSLContext sc = null;
                    try {
                        sc = SSLContext.getInstance("TLSv1.3");
                    }
                    catch (NoSuchAlgorithmException e) {
                        sc = SSLContext.getInstance("TLSv1.2");
                    }
                    sc.init(null, null, null);
                    httpsURLConnection.setSSLSocketFactory(sc.getSocketFactory());
                }
                this.mConnection.setRequestMethod(this.mConnectMethod);
                this.mConnection.setConnectTimeout(this.mConnectTimeout);
                this.mConnection.setInstanceFollowRedirects(true);
                this.mConnection.setDoOutput(this.mRequestBody != null);
                this.mConnection.setDoInput(true);
                for (Pair<String, String> header : this.mRequestHeaders) {
                    this.mConnection.setRequestProperty((String)header.first, (String)header.second);
                }
                this.doConnection();
                this.readResponse();
            }
            catch (UnknownHostException e) {
                this.mResponseStatus = 502;
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                throw new AsyncOperation.CompletionException(e);
            }
        });
        return connectAndReadResponseOperation.whenComplete((antecedentValue, antecedentException) -> {
            if (antecedentException != null) {
                Throwable innerException = this.getInnerException((Throwable)antecedentException);
                this.mErrorCode = innerException instanceof SSLException || innerException instanceof NoSuchAlgorithmException ? -2147220729 : ErrorCode.translateErrorCodeValueFromThrowable(innerException);
            }
            this.mConnection.disconnect();
            this.completeExecutionNative(NativeUtils.getNativePointer(completionCallback), this.mErrorCode, this.mResponseStatus, this.mResponseHeaderCount, this.mResponseHeaderKeys, this.mResponseHeaderValues, this.mResponseBody);
        });
    }

    private void doConnection() throws IOException {
        if (this.mConnection.getDoOutput()) {
            try (OutputStream outputStream = this.mConnection.getOutputStream();){
                HttpClient.writeStream(outputStream, this.mRequestBody);
            }
        }
        this.mConnection.connect();
    }

    private void readResponse() throws IOException {
        this.populateResponseHeaders(this.mConnection.getHeaderFields());
        this.mResponseStatus = this.mConnection.getResponseCode();
        if (this.mResponseStatus < 400) {
            try (InputStream inputStream = this.mConnection.getInputStream();){
                this.mResponseBody = HttpClient.readStream(inputStream);
            }
        }
        try (InputStream errorStream = this.mConnection.getErrorStream();){
            this.mResponseBody = HttpClient.readStream(errorStream);
        }
    }

    public void cancelRequest() {
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
    }

    private void populateResponseHeaders(Map<String, List<String>> responseHeaders) {
        ArrayList<String> headerKeys = new ArrayList<String>();
        ArrayList<String> headerValues = new ArrayList<String>();
        int headerCount = 0;
        for (Map.Entry<String, List<String>> header : responseHeaders.entrySet()) {
            String key = header.getKey();
            for (String value : header.getValue()) {
                headerKeys.add(key);
                headerValues.add(value);
                ++headerCount;
            }
        }
        this.mResponseHeaderCount = headerCount;
        this.mResponseHeaderKeys = headerKeys.toArray(new String[headerCount]);
        this.mResponseHeaderValues = headerValues.toArray(new String[headerCount]);
    }

    private Throwable getInnerException(Throwable throwable) {
        if (throwable instanceof ExecutionException) {
            return this.getInnerException(((ExecutionException)throwable).getCause());
        }
        if (throwable instanceof AsyncOperation.CompletionException) {
            return this.getInnerException(((AsyncOperation.CompletionException)throwable).getCause());
        }
        return throwable;
    }

    private native void completeExecutionNative(long var1, int var3, int var4, int var5, String[] var6, String[] var7, byte[] var8);
}

