/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.microsoft.connecteddevices.SdkException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.concurrent.RejectedExecutionException;

@Keep
enum ErrorCode {
    SUCCESS(0),
    OPERATION_PENDING(-2147483638),
    BOUNDS(-2147483637),
    ILLEGAL_METHOD_CALL(-2147483634),
    APPLICATION_EXITING(-2147483622),
    NOT_IMPLEMENTED(-2147467263),
    NO_INTERFACE(-2147467262),
    INVALID_POINTER(-2147467261),
    ABORTED(-2147467260),
    FAILED(-2147467259),
    UNEXPECTED(-2147418113),
    ACCESS_DENIED(-2147024891),
    INVALID_HANDLE(-2147024890),
    OUT_OF_MEMORY(-2147024882),
    NOT_SUPPORTED(-2147024846),
    INVALID_ARGUMENT(-2147024809),
    INSUFFICIENT_BUFFER(-2147024774),
    NOT_VALID_STATE(-2147019873),
    UNKNOWN(-1879048193);

    private final int mValue;
    private static final SparseArray<ErrorCode> mLookup;
    private static final SparseArray<Class<? extends Throwable>> mExceptionLookup;

    static ErrorCode fromInt(int value) {
        return (ErrorCode)((Object)mLookup.get(value, (Object)UNKNOWN));
    }

    @Keep
    static int translateErrorCodeValueFromThrowable(@NonNull Throwable exception) {
        if (exception == null) {
            return FAILED.getValue();
        }
        if (exception instanceof SdkException) {
            return ((SdkException)exception).getErrorCode().getValue();
        }
        for (int i = 0; i < mExceptionLookup.size(); ++i) {
            int errorCodeValue = mExceptionLookup.keyAt(i);
            Class exceptionClass = (Class)mExceptionLookup.get(errorCodeValue);
            if (exceptionClass == null || !exceptionClass.equals(exception.getClass())) continue;
            return errorCodeValue;
        }
        return FAILED.getValue();
    }

    @Keep
    static Throwable createThrowableFromErrorCodeValue(int errorValue, String message, StackTraceElement[] stackElements) {
        SdkException innerException = null;
        if (stackElements != null && stackElements.length > 0) {
            innerException = new SdkException(ErrorCode.fromInt(errorValue), message);
            innerException.setStackTrace(stackElements);
        }
        Throwable outerException = null;
        try {
            Class exceptionClass = (Class)mExceptionLookup.get(errorValue);
            if (exceptionClass != null) {
                try {
                    outerException = (Throwable)exceptionClass.getConstructor(String.class).newInstance(message);
                }
                catch (NoSuchMethodException e) {
                    outerException = (Throwable)exceptionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (outerException == null) {
            outerException = new SdkException(ErrorCode.fromInt(errorValue), message);
        }
        try {
            outerException.initCause(innerException);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return outerException;
    }

    private ErrorCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    static {
        mLookup = new SparseArray();
        mExceptionLookup = new SparseArray();
        for (ErrorCode error : ErrorCode.values()) {
            mLookup.put(error.getValue(), (Object)error);
        }
        mExceptionLookup.put(OPERATION_PENDING.getValue(), RejectedExecutionException.class);
        mExceptionLookup.put(BOUNDS.getValue(), IndexOutOfBoundsException.class);
        mExceptionLookup.put(ILLEGAL_METHOD_CALL.getValue(), IllegalAccessException.class);
        mExceptionLookup.put(APPLICATION_EXITING.getValue(), ThreadDeath.class);
        mExceptionLookup.put(NOT_IMPLEMENTED.getValue(), UnsupportedOperationException.class);
        mExceptionLookup.put(NO_INTERFACE.getValue(), ClassCastException.class);
        mExceptionLookup.put(INVALID_POINTER.getValue(), NullPointerException.class);
        mExceptionLookup.put(ABORTED.getValue(), InterruptedException.class);
        mExceptionLookup.put(UNEXPECTED.getValue(), UnknownError.class);
        mExceptionLookup.put(ACCESS_DENIED.getValue(), SecurityException.class);
        mExceptionLookup.put(INVALID_HANDLE.getValue(), IOException.class);
        mExceptionLookup.put(OUT_OF_MEMORY.getValue(), OutOfMemoryError.class);
        mExceptionLookup.put(NOT_SUPPORTED.getValue(), UnsupportedOperationException.class);
        mExceptionLookup.put(INVALID_ARGUMENT.getValue(), IllegalArgumentException.class);
        mExceptionLookup.put(INSUFFICIENT_BUFFER.getValue(), BufferOverflowException.class);
        mExceptionLookup.put(NOT_VALID_STATE.getValue(), IllegalStateException.class);
    }
}

