/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ConnectedDevicesAccountManager;
import com.microsoft.connecteddevices.ConnectedDevicesNotification;
import com.microsoft.connecteddevices.ConnectedDevicesNotificationRegistrationManager;
import com.microsoft.connecteddevices.ConnectedDevicesPlatformSettings;
import com.microsoft.connecteddevices.ConnectedDevicesProcessNotificationOperation;
import com.microsoft.connecteddevices.ConversionHelpers;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeUtils;
import java.util.Map;
import org.json.JSONException;

@Keep
public final class ConnectedDevicesPlatform
extends NativeBase {
    ConnectedDevicesPlatform(NativeObject nativeObject) {
        super(nativeObject);
    }

    public ConnectedDevicesPlatform(@NonNull Context context) {
        super(ConnectedDevicesPlatform.createInstanceNative(context.getApplicationContext()));
    }

    public ConnectedDevicesPlatform(@NonNull Context context, @NonNull ConnectedDevicesPlatformSettings settings) {
        super(ConnectedDevicesPlatform.createInstanceWithSettingsNative(context.getApplicationContext(), NativeUtils.getNativePointer(settings)));
    }

    @NonNull
    public ConnectedDevicesAccountManager getAccountManager() {
        return NativeObject.toSpecific(this.getAccountManagerNative(NativeUtils.getNativePointer(this)), ConnectedDevicesAccountManager.class);
    }

    @Deprecated
    @NonNull
    public ConnectedDevicesProcessNotificationOperation processNotification(@NonNull Bundle bundle) {
        String notification;
        try {
            notification = ConversionHelpers.bundleToJSONString(bundle);
        }
        catch (JSONException e) {
            notification = "";
        }
        return NativeObject.toSpecific(this.processNotificationNative(NativeUtils.getNativePointer(this), notification), ConnectedDevicesProcessNotificationOperation.class);
    }

    @Deprecated
    @NonNull
    public ConnectedDevicesProcessNotificationOperation processNotification(@NonNull Map map) {
        String notification;
        try {
            notification = ConversionHelpers.mapToJSONString(map);
        }
        catch (JSONException e) {
            notification = "";
        }
        return NativeObject.toSpecific(this.processNotificationNative(NativeUtils.getNativePointer(this), notification), ConnectedDevicesProcessNotificationOperation.class);
    }

    @NonNull
    public AsyncOperation<Void> processNotificationAsync(@NonNull ConnectedDevicesNotification notification) {
        AsyncOperation<Void> result = new AsyncOperation<Void>();
        this.processNotificationAsyncNative(NativeUtils.getNativePointer(this), NativeUtils.getNativePointer(notification), result);
        return result;
    }

    public void start() {
        this.startNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public AsyncOperation<Void> shutdownAsync() {
        AsyncOperation<Void> result = new AsyncOperation<Void>();
        this.shutdownAsyncNative(NativeUtils.getNativePointer(this), result);
        return result;
    }

    @NonNull
    public ConnectedDevicesNotificationRegistrationManager getNotificationRegistrationManager() {
        return NativeObject.toSpecific(this.getNotificationRegistrationManagerNative(NativeUtils.getNativePointer(this)), ConnectedDevicesNotificationRegistrationManager.class);
    }

    private static native NativeObject createInstanceNative(Context var0);

    private static native NativeObject createInstanceWithSettingsNative(Context var0, long var1);

    private native NativeObject getAccountManagerNative(long var1);

    private native NativeObject processNotificationNative(long var1, String var3);

    private native void processNotificationAsyncNative(long var1, long var3, AsyncOperation<Void> var5);

    private native void startNative(long var1);

    private native void shutdownAsyncNative(long var1, AsyncOperation<Void> var3);

    private native NativeObject getNotificationRegistrationManagerNative(long var1);
}

