/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import Microsoft.Android.LoggingLibrary.Snapshot;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.ISingletonCll;
import com.microsoft.cll.android.ScheduledWorker;
import com.microsoft.cll.android.SettingsStore;
import java.util.EnumSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SnapshotScheduler
extends ScheduledWorker {
    private final String TAG = "AndroidCll-SnapshotScheduler";
    private final ISingletonCll cll;
    private final ClientTelemetry clientTelemetry;
    private final ILogger logger;

    public SnapshotScheduler(ClientTelemetry clientTelemetry, ILogger logger, ISingletonCll cll) {
        super(SettingsStore.getCllSettingsAsLong(SettingsStore.Settings.SNAPSHOTSCHEDULEINTERVAL));
        this.cll = cll;
        this.clientTelemetry = clientTelemetry;
        this.logger = logger;
    }

    @Override
    public void start(ScheduledExecutorService executor) {
        this.executor = executor;
        this.nextExecution = executor.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.SECONDS);
    }

    @Override
    public void resume(ScheduledExecutorService executor) {
        this.executor = executor;
        this.nextExecution = executor.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.SECONDS);
        this.isPaused = false;
    }

    @Override
    public void run() {
        this.logger.info("AndroidCll-SnapshotScheduler", "Uploading snapshot");
        if (this.interval != (long)SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.SNAPSHOTSCHEDULEINTERVAL)) {
            this.nextExecution.cancel(false);
            this.interval = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.SNAPSHOTSCHEDULEINTERVAL);
            this.nextExecution = this.executor.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.SECONDS);
        }
        this.recordStatistics();
    }

    private void recordStatistics() {
        Snapshot snapshot = this.clientTelemetry.GetEvent();
        this.cll.log(snapshot, EventEnums.Latency.LatencyUnspecified, EventEnums.Persistence.PersistenceUnspecified, EnumSet.of(EventEnums.Sensitivity.SensitivityUnspecified), -1.0, null);
        this.clientTelemetry.Reset();
    }
}

