/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding.nearshare;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class NearShareStreamImpl
implements NearShareStream {
    private FileChannel mFileChannel = null;

    public NearShareStreamImpl(Uri fileUri, Context context) throws IOException {
        AssetFileDescriptor assetFileDescriptor = context.getContentResolver().openAssetFileDescriptor(fileUri, "r");
        this.mFileChannel = assetFileDescriptor.createInputStream().getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long offset, int size, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.clear();
        NearShareStreamImpl nearShareStreamImpl = this;
        synchronized (nearShareStreamImpl) {
            this.mFileChannel.read(byteBuffer, offset);
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.mFileChannel && this.mFileChannel.isOpen()) {
            this.mFileChannel.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

