/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.EventListener;
import com.microsoft.connecteddevices.EventSubscription;
import java.util.HashSet;

@Keep
public class EventSource<T, R>
implements Event<T, R> {
    private final HashSet<EventListener<? super T, ? super R>> mListeners = new HashSet();

    @Override
    public synchronized EventSubscription subscribe(EventListener<? super T, ? super R> listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mListeners.add(listener);
        return () -> this.removeListener(listener);
    }

    synchronized void removeListener(EventListener<? super T, ? super R> listener) {
        this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(T source, R args) {
        HashSet listeners;
        EventSource eventSource = this;
        synchronized (eventSource) {
            listeners = (HashSet)this.mListeners.clone();
        }
        for (EventListener listener : listeners) {
            listener.onEvent(source, args);
        }
    }
}

