/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.support.annotation.Keep;
import java.security.InvalidParameterException;

@Keep
class AFCQueryExecHelper {
    private SQLiteDatabase mDatabase;
    private Object[] mBindings;
    private String mSql;

    public AFCQueryExecHelper(SQLiteDatabase database, String sql, Object[] bindings) {
        this.mDatabase = database;
        this.mSql = sql;
        this.mBindings = bindings;
    }

    public Cursor ExecuteSql() {
        Cursor cursor = this.mDatabase.rawQueryWithFactory((SQLiteDatabase.CursorFactory)new CustomCursorFactory(this.mBindings), this.mSql, null, null);
        return cursor;
    }

    private class CustomCursorFactory
    implements SQLiteDatabase.CursorFactory {
        private Object[] mBindings;

        public CustomCursorFactory(Object[] bindings) {
            this.mBindings = bindings;
        }

        public Cursor newCursor(SQLiteDatabase database, SQLiteCursorDriver masterQuery, String editTable, SQLiteQuery query) {
            for (int i = 1; i <= this.mBindings.length; ++i) {
                Object obj = this.mBindings[i - 1];
                if (obj == null) {
                    query.bindNull(i);
                    continue;
                }
                if (obj instanceof Integer || obj instanceof Long) {
                    query.bindLong(i, ((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Float || obj instanceof Double) {
                    query.bindDouble(i, ((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof String) {
                    query.bindString(i, (String)obj);
                    continue;
                }
                if (obj instanceof byte[]) {
                    query.bindBlob(i, (byte[])obj);
                    continue;
                }
                throw new InvalidParameterException("Unknown SQL binding parameter type");
            }
            return new SQLiteCursor(masterQuery, editTable, query);
        }
    }
}

