/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractHandler;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.FileStorage;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.Tuple;
import java.io.IOException;
import java.util.List;

public class CriticalEventHandler
extends AbstractHandler {
    private final String TAG = "AndroidCll-CriticalEventHandler";

    public CriticalEventHandler(ILogger logger, String filePath, ClientTelemetry clientTelemetry) {
        super(logger, filePath, clientTelemetry);
        this.fileStorage = new FileStorage(".crit.cllevent", logger, filePath, this);
    }

    @Override
    public synchronized void add(String event, List<String> ids) throws IOException, FileStorage.FileFullException {
        Tuple<String, List<String>> tuple = new Tuple<String, List<String>>(event, ids);
        boolean canAddResult = this.ensureCanAdd(tuple, EventEnums.Persistence.PersistenceCritical);
        if (!canAddResult) {
            this.clientTelemetry.IncrementEventsDroppedDueToQuota();
            this.logger.warn("AndroidCll-CriticalEventHandler", "Out of storage space for critical events. Logged event was dropped.");
        }
        if (!this.fileStorage.canAdd(tuple)) {
            this.logger.info("AndroidCll-CriticalEventHandler", "Closing full file and opening a new one");
            this.fileStorage.close();
            this.fileStorage = new FileStorage(".crit.cllevent", this.logger, this.filePath, this);
        }
        this.fileStorage.add(tuple);
        totalStorageUsed.getAndAdd(event.length());
        this.fileStorage.flush();
    }

    @Override
    public synchronized List<IStorage> getFilesForDraining() {
        List<IStorage> storageList;
        if (this.fileStorage.size() > 0L) {
            this.fileStorage.close();
            storageList = this.getFilesByExtensionForDraining(".crit.cllevent");
            this.fileStorage = new FileStorage(".crit.cllevent", this.logger, this.filePath, this);
        } else {
            storageList = this.getFilesByExtensionForDraining(".crit.cllevent");
        }
        return storageList;
    }

    @Override
    public void close() {
        this.logger.info("AndroidCll-CriticalEventHandler", "Closing critical file");
        this.fileStorage.close();
    }

    @Override
    public void dispose(IStorage storage) {
        totalStorageUsed.getAndAdd(-1L * storage.size());
    }
}

