/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata.useractivities;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.NativeObjectListAsyncOperation;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.userdata.UserDataFeed;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.userdata.useractivities.UserActivity;
import com.microsoft.connecteddevices.userdata.useractivities.UserActivitySessionHistoryItem;
import java.util.Date;
import java.util.List;

@Keep
public final class UserActivityChannel
extends NativeBase {
    UserActivityChannel(NativeObject obj) {
        super(obj);
    }

    public UserActivityChannel(@NonNull UserDataFeed userDataFeed) {
        super(UserActivityChannel.createInstanceNative(NativeUtils.getNativePointer(userDataFeed)));
    }

    @NonNull
    public AsyncOperation<UserActivity> getOrCreateUserActivityAsync(@NonNull String activityId) {
        NativeObjectAsyncOperation<UserActivity> callback = new NativeObjectAsyncOperation<UserActivity>(UserActivity::new);
        this.getOrCreateUserActivityAsyncNative(NativeUtils.getNativePointer(this), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteActivityAsync(@NonNull String activityId) {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteActivityAsyncNative(NativeUtils.getNativePointer(this), activityId, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<Void> deleteAllActivitiesAsync() {
        AsyncOperation<Void> callback = new AsyncOperation<Void>();
        this.deleteAllActivitiesAsyncNative(NativeUtils.getNativePointer(this), callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<List<UserActivitySessionHistoryItem>> getRecentUserActivitiesAsync(int maxUniqueActivities) {
        NativeObjectListAsyncOperation<Object> callback = new NativeObjectListAsyncOperation<Object>(UserActivitySessionHistoryItem::new);
        this.getRecentUserActivitiesAsyncNative(NativeUtils.getNativePointer(this), maxUniqueActivities, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<List<UserActivitySessionHistoryItem>> getSessionHistoryItemsForUserActivityAsync(@NonNull String activityId, @NonNull Date startTime) {
        NativeObjectListAsyncOperation<Object> callback = new NativeObjectListAsyncOperation<Object>(UserActivitySessionHistoryItem::new);
        this.getSessionHistoryItemsForUserActivityAsyncNative(NativeUtils.getNativePointer(this), activityId, startTime, callback);
        return callback;
    }

    @NonNull
    public AsyncOperation<List<UserActivitySessionHistoryItem>> getRecentSessionHistoryItemsForTimeRangeAsync(@NonNull Date startTime, @NonNull Date endTime, int maxActivities) {
        NativeObjectListAsyncOperation<Object> callback = new NativeObjectListAsyncOperation<Object>(UserActivitySessionHistoryItem::new);
        this.getRecentSessionHistoryItemsForTimeRangeAsyncNative(NativeUtils.getNativePointer(this), startTime, endTime, maxActivities, callback);
        return callback;
    }

    public void setAppDisplayName(@Nullable String appDisplayName) {
        this.setAppDisplayNameNative(NativeUtils.getNativePointer(this), appDisplayName);
    }

    @Nullable
    public String getAppDisplayName() {
        return this.getAppDisplayNameNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public static UserDataFeedSyncScope getSyncScope() {
        return NativeObject.toSpecific(UserActivityChannel.getSyncScopeNative(), UserDataFeedSyncScope.class);
    }

    private native void getOrCreateUserActivityAsyncNative(long var1, String var3, AsyncOperation<UserActivity> var4);

    private native void deleteActivityAsyncNative(long var1, String var3, AsyncOperation<Void> var4);

    private native void deleteAllActivitiesAsyncNative(long var1, AsyncOperation<Void> var3);

    private native void getRecentUserActivitiesAsyncNative(long var1, int var3, AsyncOperation<List<UserActivitySessionHistoryItem>> var4);

    private native void getSessionHistoryItemsForUserActivityAsyncNative(long var1, String var3, Date var4, AsyncOperation<List<UserActivitySessionHistoryItem>> var5);

    private native void getRecentSessionHistoryItemsForTimeRangeAsyncNative(long var1, Date var3, Date var4, int var5, AsyncOperation<List<UserActivitySessionHistoryItem>> var6);

    private native void setAppDisplayNameNative(long var1, String var3);

    private native String getAppDisplayNameNative(long var1);

    private static native NativeObject createInstanceNative(long var0);

    private static native NativeObject getSyncScopeNative();
}

