/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemApp;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemPlatform;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemStatus;
import java.util.List;

@Keep
public final class RemoteSystem
extends NativeBase {
    RemoteSystem(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public String getKind() {
        return this.getKindNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public String getId() {
        return this.getIdNative(NativeUtils.getNativePointer(this));
    }

    @Nullable
    public String getDisplayName() {
        return this.getDisplayNameNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public RemoteSystemStatus getStatus() {
        return RemoteSystemStatus.fromInt(this.getStatusNative(NativeUtils.getNativePointer(this)));
    }

    @NonNull
    public String getManufacturerDisplayName() {
        return this.getManufacturerDisplayNameNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public String getModelDisplayName() {
        return this.getModelDisplayNameNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public List<RemoteSystemApp> getApps() {
        return NativeObject.toSpecificList(this.getAppsNative(NativeUtils.getNativePointer(this)), RemoteSystemApp::new);
    }

    @NonNull
    RemoteSystemPlatform getPlatform() {
        return RemoteSystemPlatform.fromInt(this.getRemoteSystemPlatformNative(NativeUtils.getNativePointer(this)));
    }

    private native String getKindNative(long var1);

    private native String getIdNative(long var1);

    private native String getDisplayNameNative(long var1);

    private native int getStatusNative(long var1);

    private native int getRemoteSystemPlatformNative(long var1);

    private native String getManufacturerDisplayNameNative(long var1);

    private native String getModelDisplayNameNative(long var1);

    private native NativeObject[] getAppsNative(long var1);
}

