/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.net.Uri;
import android.support.annotation.Keep;

@Keep
class UriHelper {
    UriHelper() {
    }

    static boolean isValidAbsoluteUri(String uriString, int uriRestriction) {
        UriRestriction restriction = UriRestriction.fromInt(uriRestriction);
        boolean ret = false;
        try {
            Uri uri = Uri.parse((String)uriString);
            String scheme = uri.getScheme();
            if (restriction == UriRestriction.NO_RESTRICTION) {
                ret = !scheme.isEmpty();
            } else if (restriction == UriRestriction.HTTP_ONLY) {
                ret = scheme.equalsIgnoreCase("HTTP") || scheme.equalsIgnoreCase("HTTPS");
            } else if (restriction == UriRestriction.HTTP_OR_FILE_ONLY) {
                ret = scheme.equalsIgnoreCase("HTTP") || scheme.equalsIgnoreCase("HTTPS") || scheme.equalsIgnoreCase("FILE");
            }
            ret &= uri.isAbsolute();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static enum UriRestriction {
        NO_RESTRICTION(0),
        HTTP_ONLY(1),
        HTTP_OR_FILE_ONLY(2);

        private final int mValue;

        private UriRestriction(int value) {
            this.mValue = value;
        }

        static UriRestriction fromInt(int value) {
            return UriRestriction.values()[value];
        }

        int getValue() {
            return this.mValue;
        }
    }
}

