/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import java.util.EnumSet;

public final class EventEnums {
    public static final double SampleRate_NoSampling = 100.0;
    public static final double SampleRate_10_percent = 10.0;
    public static final double SampleRate_0_percent = 0.0;
    public static final double SampleRate_Unspecified = -1.0;
    public static final double SampleRate_Epsilon = 1.0E-5;

    private EventEnums() {
        throw new AssertionError();
    }

    static double SampleRateFromString(String s) {
        double d = 100.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static enum Sensitivity {
        SensitivityUnspecified(1),
        SensitivityNone(0),
        SensitivityMark(524288),
        SensitivityHash(0x100000),
        SensitivityDrop(0x200000);

        public final int id;

        private Sensitivity(int id) {
            this.id = id;
        }

        static EnumSet<Sensitivity> FromString(String s) {
            EnumSet<Sensitivity> sensitivity = EnumSet.noneOf(Sensitivity.class);
            if (s != null) {
                if (s.contains("MARK") || s.toUpperCase().contains("USERSENSITIVE")) {
                    sensitivity.add(SensitivityMark);
                }
                if (s.contains("DROP")) {
                    sensitivity.add(SensitivityDrop);
                }
                if (s.contains("HASH")) {
                    sensitivity.add(SensitivityHash);
                }
            }
            return sensitivity;
        }
    }

    public static enum Persistence {
        PersistenceUnspecified(0),
        PersistenceNormal(1),
        PersistenceCritical(2);

        public final int id;

        private Persistence(int id) {
            this.id = id;
        }

        static Persistence FromString(String s) {
            if (s.equals("CRITICAL")) {
                return PersistenceCritical;
            }
            return PersistenceNormal;
        }
    }

    public static enum Latency {
        LatencyUnspecified(0),
        LatencyNormal(256),
        LatencyRealtime(512);

        public final int id;

        private Latency(int id) {
            this.id = id;
        }

        static Latency FromString(String s) {
            if (s.equals("REALTIME")) {
                return LatencyRealtime;
            }
            return LatencyNormal;
        }
    }
}

