/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding.nearshare;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareFileProvider;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareStream;
import com.microsoft.connecteddevices.remotesystems.commanding.nearshare.NearShareStreamImpl;
import java.io.IOException;

final class NearShareFileProviderImpl
implements NearShareFileProvider {
    private final Uri mContentUri;
    private String mFilename = "";
    private long mFilesize = -1L;
    private Context mContext;

    public NearShareFileProviderImpl(Uri contentUri, Context context) {
        if (!contentUri.getScheme().equals("content")) {
            throw new IllegalArgumentException("URI scheme does not match content URI");
        }
        this.mContentUri = contentUri;
        this.mContext = context;
    }

    @Override
    public String getFileName() {
        if (null == this.mFilename || this.mFilename.isEmpty()) {
            this.getMetadata();
        }
        return this.mFilename;
    }

    @Override
    public long getSize() {
        if (-1L == this.mFilesize) {
            this.getMetadata();
        }
        return this.mFilesize;
    }

    @Override
    public NearShareStream open() throws IOException {
        return new NearShareStreamImpl(this.mContentUri, this.mContext);
    }

    private void getMetadata() {
        try (Cursor cursor = this.mContext.getContentResolver().query(this.mContentUri, new String[]{"_display_name", "_size"}, null, null, null);){
            if (null != cursor) {
                cursor.moveToFirst();
                this.mFilename = cursor.getString(0);
                this.mFilesize = cursor.getLong(1);
            }
        }
    }
}

