/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemAddedEventArgs;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemEnumerationCompletedEventArgs;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemFilter;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemRemovedEventArgs;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemUpdatedEventArgs;
import com.microsoft.connecteddevices.remotesystems.RemoteSystemWatcherErrorOccurredEventArgs;
import java.util.Collection;

@Keep
public final class RemoteSystemWatcher
extends NativeBase {
    private Event<RemoteSystemWatcher, RemoteSystemAddedEventArgs> mRemoteSystemAdded = new NativeEvent<RemoteSystemWatcher, RemoteSystemAddedEventArgs>(this, this::addRemoteSystemAddedListenerNative, this::removeRemoteSystemAddedListenerNative, RemoteSystemWatcher::new, RemoteSystemAddedEventArgs::new);
    private Event<RemoteSystemWatcher, RemoteSystemUpdatedEventArgs> mRemoteSystemUpdated = new NativeEvent<RemoteSystemWatcher, RemoteSystemUpdatedEventArgs>(this, this::addRemoteSystemUpdatedListenerNative, this::removeRemoteSystemUpdatedListenerNative, RemoteSystemWatcher::new, RemoteSystemUpdatedEventArgs::new);
    private Event<RemoteSystemWatcher, RemoteSystemRemovedEventArgs> mRemoteSystemRemoved = new NativeEvent<RemoteSystemWatcher, RemoteSystemRemovedEventArgs>(this, this::addRemoteSystemRemovedListenerNative, this::removeRemoteSystemRemovedListenerNative, RemoteSystemWatcher::new, RemoteSystemRemovedEventArgs::new);
    private Event<RemoteSystemWatcher, RemoteSystemWatcherErrorOccurredEventArgs> mErrorOccurred = new NativeEvent<RemoteSystemWatcher, RemoteSystemWatcherErrorOccurredEventArgs>(this, this::addErrorOccurredListenerNative, this::removeErrorOccurredListenerNative, RemoteSystemWatcher::new, RemoteSystemWatcherErrorOccurredEventArgs::new);
    private Event<RemoteSystemWatcher, RemoteSystemEnumerationCompletedEventArgs> mEnumerationCompleted = new NativeEvent<RemoteSystemWatcher, RemoteSystemEnumerationCompletedEventArgs>(this, this::addEnumerationCompletedListenerNative, this::removeEnumerationCompletedListenerNative, RemoteSystemWatcher::new, RemoteSystemEnumerationCompletedEventArgs::new);

    public RemoteSystemWatcher() {
        super(RemoteSystemWatcher.createInstanceNative());
    }

    public RemoteSystemWatcher(@NonNull Collection<RemoteSystemFilter> filters) {
        super(RemoteSystemWatcher.createInstanceNative(NativeUtils.convertToNativeArray(filters, RemoteSystemFilter.class)));
    }

    RemoteSystemWatcher(NativeObject nativeObject) {
        super(nativeObject);
    }

    public void start() {
        this.startNative(NativeUtils.getNativePointer(this));
    }

    public void stop() {
        this.stopNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public Event<RemoteSystemWatcher, RemoteSystemAddedEventArgs> remoteSystemAdded() {
        return this.mRemoteSystemAdded;
    }

    @NonNull
    public Event<RemoteSystemWatcher, RemoteSystemUpdatedEventArgs> remoteSystemUpdated() {
        return this.mRemoteSystemUpdated;
    }

    @NonNull
    public Event<RemoteSystemWatcher, RemoteSystemRemovedEventArgs> remoteSystemRemoved() {
        return this.mRemoteSystemRemoved;
    }

    @NonNull
    public Event<RemoteSystemWatcher, RemoteSystemWatcherErrorOccurredEventArgs> errorOccurred() {
        return this.mErrorOccurred;
    }

    @NonNull
    public Event<RemoteSystemWatcher, RemoteSystemEnumerationCompletedEventArgs> enumerationCompleted() {
        return this.mEnumerationCompleted;
    }

    private static native NativeObject createInstanceNative();

    private static native NativeObject createInstanceNative(long[] var0);

    private native void startNative(long var1);

    private native void stopNative(long var1);

    private native long addRemoteSystemAddedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystemAddedEventArgs> var3);

    private native void removeRemoteSystemAddedListenerNative(long var1, long var3);

    private native long addRemoteSystemUpdatedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystemUpdatedEventArgs> var3);

    private native void removeRemoteSystemUpdatedListenerNative(long var1, long var3);

    private native long addRemoteSystemRemovedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystemRemovedEventArgs> var3);

    private native void removeRemoteSystemRemovedListenerNative(long var1, long var3);

    private native long addEnumerationCompletedListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystemEnumerationCompletedEventArgs> var3);

    private native void removeEnumerationCompletedListenerNative(long var1, long var3);

    private native long addErrorOccurredListenerNative(long var1, NativeObjectEventListener<RemoteSystemWatcher, RemoteSystemWatcherErrorOccurredEventArgs> var3);

    private native void removeErrorOccurredListenerNative(long var1, long var3);
}

