/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.connecteddevices.ConnectedDevicesAccount;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.remotesystems.AppServiceInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Keep
public final class RemoteSystemApp
extends NativeBase {
    RemoteSystemApp(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public String getId() {
        return this.getIdNative(NativeUtils.getNativePointer(this));
    }

    @NonNull
    public String getDisplayName() {
        return this.getDisplayNameNative(NativeUtils.getNativePointer(this));
    }

    public boolean getIsAvailableByProximity() {
        return this.getIsAvailableByProximityNative(NativeUtils.getNativePointer(this));
    }

    public boolean getIsAvailableBySpatialProximity() {
        return this.getIsAvailableBySpatialProximityNative(NativeUtils.getNativePointer(this));
    }

    @Nullable
    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = this.getAttributesNative(NativeUtils.getNativePointer(this));
        return Collections.unmodifiableMap(attributes);
    }

    @Nullable
    public List<AppServiceInfo> getAppServices() {
        return NativeObject.toSpecificList(this.getAppServicesNative(NativeUtils.getNativePointer(this)), AppServiceInfo::new);
    }

    @Nullable
    public List<ConnectedDevicesAccount> getAccounts() {
        return NativeObject.toSpecificList(this.getAccountsNative(NativeUtils.getNativePointer(this)), obj -> NativeObject.toSpecific(obj, ConnectedDevicesAccount.class));
    }

    private native String getIdNative(long var1);

    private native String getDisplayNameNative(long var1);

    private native boolean getIsAvailableByProximityNative(long var1);

    private native boolean getIsAvailableBySpatialProximityNative(long var1);

    private native HashMap<String, String> getAttributesNative(long var1);

    private native NativeObject[] getAppServicesNative(long var1);

    private native NativeObject[] getAccountsNative(long var1);
}

