/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.Keep;
import android.support.annotation.RequiresPermission;
import com.microsoft.connecteddevices.BluetoothWrapper;
import com.microsoft.connecteddevices.BluetoothWrapperImpl;
import java.util.List;

@Keep
@TargetApi(value=21)
final class BluetoothWrapperImplModern
extends BluetoothWrapperImpl {
    private static BluetoothLeScanner _leScanner;
    private static ScanCallback _leScanCallback;

    BluetoothWrapperImplModern() {
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public boolean initializeBLE(Context context) {
        if (!this.shouldInitialize(context)) {
            return false;
        }
        if (!super.initializeBLE(context)) {
            return false;
        }
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            _leScanner = adapter.getBluetoothLeScanner();
            _leScanCallback = new LeScanCallback();
        }
        catch (SecurityException e) {
            BluetoothWrapper.traceWarning("Exception initializing BLE discovery. message: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    void uninitialize() {
        try {
            if (_leScanner != null) {
                _leScanner.flushPendingScanResults(_leScanCallback);
            }
        }
        catch (IllegalStateException e) {
            BluetoothWrapper.traceWarning("Uninitializing with BT adapter disabled: If adapter was disabled during a scan, pending results may have been lost. message: " + e.getMessage());
        }
        finally {
            super.uninitialize();
        }
    }

    @Override
    public boolean isInitialized() {
        return _leScanner != null && _leScanCallback != null && super.isInitialized();
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.ACCESS_COARSE_LOCATION"})
    public void startScan(Context context) {
        if (this.ensureInitialized(context, "startScan")) {
            _leScanner.startScan(_leScanCallback);
            this.setScanStarted(true);
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public void stopScan(Context context) {
        if (this.ensureInitialized(context, "stopScan")) {
            this.stopScanInternal();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    boolean stopScanInternal() {
        boolean stopRequested = false;
        if (!this.wasScanStarted()) {
            BluetoothWrapper.traceWarning("Called 'stopScan' before starting a scan");
        }
        if (_leScanCallback == null) {
            BluetoothWrapper.traceWarning("Unable to 'stopScan': Scan callback is null");
        } else if (_leScanner == null) {
            BluetoothWrapper.traceWarning("Unable to 'stopScan': LE Scanner is null");
        } else {
            try {
                _leScanner.stopScan(_leScanCallback);
                stopRequested = true;
            }
            catch (IllegalStateException e) {
                BluetoothWrapper.traceWarning("Failed to stop BLE scan. message: " + e.getMessage());
            }
        }
        return this.setScanStarted(!stopRequested);
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH", conditional=true)
    public boolean hasBluetoothCapability(Context context) {
        return this.hasLocationServiceEnabled(context) && super.hasBluetoothCapability(context);
    }

    @Override
    public boolean hasRequiredFeatures(Context context) {
        boolean hasLocationFeature = context.getPackageManager().hasSystemFeature("android.hardware.location");
        if (!hasLocationFeature) {
            BluetoothWrapper.traceWarning("Device is not capable of determining Location");
        }
        return hasLocationFeature && super.hasRequiredFeatures(context);
    }

    @Override
    public boolean hasRequiredPermissions(Context context) {
        boolean hasCourseLocationPermission;
        boolean hasBluetoothAdminPermission = context.checkCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN") == 0;
        boolean bl = hasCourseLocationPermission = context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0;
        if (!hasBluetoothAdminPermission) {
            BluetoothWrapper.traceWarning("Required permission BLUETOOTH_ADMIN has not been granted");
        }
        if (!hasCourseLocationPermission) {
            BluetoothWrapper.traceWarning("Required permission COURSE_LOCATION has not been granted");
        }
        return hasBluetoothAdminPermission && hasCourseLocationPermission && super.hasRequiredPermissions(context);
    }

    private boolean hasLocationServiceEnabled(Context context) {
        try {
            int locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            if (locationMode == 0) {
                BluetoothWrapper.traceWarning("Location services are disabled. Required for BLE scanning on API 21+");
                return false;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            BluetoothWrapper.traceWarning("Exception while checking location services status." + e.getMessage());
            return false;
        }
        return true;
    }

    private class LeScanCallback
    extends ScanCallback {
        private LeScanCallback() {
        }

        public void onScanResult(int callbackType, ScanResult result) {
            if (callbackType != 1) {
                BluetoothWrapper.traceWarning("Unexpected scan callback type: " + callbackType);
            }
            try {
                BluetoothDevice device = result.getDevice();
                ScanRecord record = result.getScanRecord();
                int rawRssi = result.getRssi();
                if (record == null) {
                    BluetoothWrapper.traceWarning("Scan record is null, ignoring scan result");
                    return;
                }
                byte[] manufacturerData = record.getManufacturerSpecificData(6);
                BluetoothWrapperImplModern.this.handleScanResult(device, manufacturerData, rawRssi);
            }
            catch (Exception e) {
                BluetoothWrapper.traceWarning("Exception handling scan result. message: " + e.getMessage());
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            for (ScanResult result : results) {
                this.onScanResult(1, result);
            }
        }

        public void onScanFailed(int errorCode) {
            BluetoothWrapper.traceWarning("Scan Failed: " + this.getScanErrorDescription(errorCode));
        }

        private String getScanErrorDescription(int errorCode) {
            switch (errorCode) {
                case 1: {
                    return "A scan with the same settings is already started.";
                }
                case 2: {
                    return "Unable to register application with the Bluetooth adapter.";
                }
                case 3: {
                    return "An internal error occurred when trying to start scan.";
                }
            }
            return "Unknown scan error. Error Code: " + errorCode;
        }
    }
}

