/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata.usernotifications;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.userdata.UserDataFeed;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotification;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotificationReader;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotificationReaderOptions;
import com.microsoft.connecteddevices.userdata.usernotifications.UserNotificationUpdateResult;

@Keep
public final class UserNotificationChannel
extends NativeBase {
    UserNotificationChannel(NativeObject nativeObject) {
        super(nativeObject);
    }

    public UserNotificationChannel(@NonNull UserDataFeed userDataFeed) {
        super(UserNotificationChannel.createInstanceNative(NativeUtils.getNativePointer(userDataFeed)));
    }

    @NonNull
    public UserNotificationReader createReader() {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderNative(this.getNativePointer()), UserNotificationReader::new);
    }

    @NonNull
    public UserNotificationReader createReaderWithOptions(@NonNull UserNotificationReaderOptions options) {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderWithOptionsNative(this.getNativePointer(), NativeUtils.getNativePointer(options)), UserNotificationReader::new);
    }

    @NonNull
    public UserNotificationReader createReaderWithState(@NonNull String serializedState) {
        return NativeObject.toSpecific(UserNotificationChannel.createReaderWithStateNative(this.getNativePointer(), serializedState), UserNotificationReader::new);
    }

    @NonNull
    public AsyncOperation<UserNotification> getUserNotificationAsync(@NonNull String notificationId) {
        NativeObjectAsyncOperation<UserNotification> operation = new NativeObjectAsyncOperation<UserNotification>(UserNotification::new);
        UserNotificationChannel.getUserNotificationAsyncNative(this.getNativePointer(), notificationId, operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<UserNotificationUpdateResult> deleteUserNotificationAsync(@NonNull String notificationId) {
        NativeObjectAsyncOperation<UserNotificationUpdateResult> operation = new NativeObjectAsyncOperation<UserNotificationUpdateResult>(UserNotificationUpdateResult::new);
        UserNotificationChannel.deleteUserNotificationAsyncNative(this.getNativePointer(), notificationId, operation);
        return operation;
    }

    @NonNull
    public static UserDataFeedSyncScope getSyncScope() {
        return NativeObject.toSpecific(UserNotificationChannel.getSyncScopeNative(), UserDataFeedSyncScope.class);
    }

    private static native NativeObject createInstanceNative(long var0);

    private static native NativeObject createReaderNative(long var0);

    private static native NativeObject createReaderWithOptionsNative(long var0, long var2);

    private static native NativeObject createReaderWithStateNative(long var0, String var2);

    private static native void getUserNotificationAsyncNative(long var0, String var2, NativeObjectAsyncOperation<UserNotification> var3);

    private static native void deleteUserNotificationAsyncNative(long var0, String var2, NativeObjectAsyncOperation<UserNotificationUpdateResult> var3);

    private static native NativeObject getSyncScopeNative();
}

