/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.userdata;

import android.support.annotation.IntRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ConnectedDevicesAccount;
import com.microsoft.connecteddevices.ConnectedDevicesPlatform;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeBooleanAsyncOperation;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncScope;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncStatus;
import com.microsoft.connecteddevices.userdata.UserDataFeedSyncStatusChangedEventArgs;
import java.util.Collection;

@Keep
public final class UserDataFeed
extends NativeBase {
    private Event<UserDataFeed, UserDataFeedSyncStatusChangedEventArgs> mSyncStatusChanged = new NativeEvent<UserDataFeed, UserDataFeedSyncStatusChangedEventArgs>(this, this::addSyncStatusChangedListenerNative, this::removeSyncStatusChangedListenerNative, UserDataFeed::new, UserDataFeedSyncStatusChangedEventArgs::new);

    UserDataFeed(NativeObject obj) {
        super(obj);
    }

    @NonNull
    public static UserDataFeed getForAccount(@NonNull ConnectedDevicesAccount userConnectedDevicesAccount, @NonNull ConnectedDevicesPlatform platform, @NonNull String activitySourceHost) {
        return NativeObject.toSpecific(UserDataFeed.getForAccountNative(NativeUtils.getNativePointer(userConnectedDevicesAccount), NativeUtils.getNativePointer(platform), activitySourceHost), UserDataFeed::new);
    }

    public AsyncOperation<Boolean> subscribeToSyncScopesAsync(@NonNull Collection<UserDataFeedSyncScope> syncScopes) {
        NativeBooleanAsyncOperation operation = new NativeBooleanAsyncOperation();
        this.subscribeToSyncScopesAsyncNative(this.getNativePointer(), NativeUtils.convertToNativeArray(syncScopes, UserDataFeedSyncScope.class), operation);
        return operation;
    }

    public void setDaysToSync(@IntRange(from=0L) int daysToSync) {
        this.setDaysToSyncNative(this.getNativePointer(), daysToSync);
    }

    public int getDaysToSync() {
        return this.getDaysToSyncNative(this.getNativePointer());
    }

    @NonNull
    public Event<UserDataFeed, UserDataFeedSyncStatusChangedEventArgs> syncStatusChanged() {
        return this.mSyncStatusChanged;
    }

    public void startSync() {
        this.startSyncNative(this.getNativePointer());
    }

    public UserDataFeedSyncStatus getSyncStatus() {
        return UserDataFeedSyncStatus.fromInt(this.getSyncStatusNative(this.getNativePointer()));
    }

    private native void subscribeToSyncScopesAsyncNative(long var1, long[] var3, AsyncOperation<Boolean> var4);

    private native void setDaysToSyncNative(long var1, int var3);

    private native int getDaysToSyncNative(long var1);

    private native int getSyncStatusNative(long var1);

    private native void startSyncNative(long var1);

    private native long addSyncStatusChangedListenerNative(long var1, NativeObjectEventListener<UserDataFeed, UserDataFeedSyncStatusChangedEventArgs> var3);

    private native void removeSyncStatusChangedListenerNative(long var1, long var3);

    private static native NativeObject getForAccountNative(long var0, long var2, String var4);
}

