/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.EventListener;
import com.microsoft.connecteddevices.EventSubscription;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectEventListener;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeEvent<TSourceObject extends NativeBase, TArgObject extends NativeBase>
implements Event<TSourceObject, TArgObject> {
    private final NativeBase mEventSource;
    private final NativeEventSubscriber mSubscriber;
    private final NativeEventUnsubscriber mUnsubscriber;
    private final NativeObject.Creator<TSourceObject> mSourceCreator;
    private final NativeObject.Creator<TArgObject> mArgCreator;

    public NativeEvent(NativeBase eventSource, NativeEventSubscriber subscriber, NativeEventUnsubscriber unsubscriber, NativeObject.Creator<TSourceObject> sourceCreator, NativeObject.Creator<TArgObject> argCreator) {
        this.mEventSource = eventSource;
        this.mSubscriber = subscriber;
        this.mUnsubscriber = unsubscriber;
        this.mSourceCreator = sourceCreator;
        this.mArgCreator = argCreator;
    }

    @Override
    public EventSubscription subscribe(EventListener<? super TSourceObject, ? super TArgObject> listener) {
        return new NativeEventSubscription(this.mEventSource, this.mSubscriber.subscribe(this.mEventSource.getNativePointer(), new NativeObjectEventListener<TSourceObject, TArgObject>(this.mSourceCreator, this.mArgCreator, listener)), this.mUnsubscriber);
    }

    private final class NativeEventSubscription
    implements EventSubscription {
        private final NativeBase mEventSource;
        private final long mToken;
        private final NativeEventUnsubscriber mUnsubscriber;

        NativeEventSubscription(NativeBase eventSource, long token, NativeEventUnsubscriber unsubscriber) {
            this.mEventSource = eventSource;
            this.mToken = token;
            this.mUnsubscriber = unsubscriber;
        }

        @Override
        public void cancel() {
            this.mUnsubscriber.unsubscribe(this.mEventSource.getNativePointer(), this.mToken);
        }
    }

    public static interface NativeEventUnsubscriber<TSourceObject extends NativeBase, TArgObject> {
        public void unsubscribe(long var1, long var3);
    }

    public static interface NativeEventSubscriber<TSourceObject extends NativeBase, TArgObject extends NativeBase> {
        public long subscribe(long var1, NativeObjectEventListener<? super TSourceObject, ? super TArgObject> var3);
    }
}

